/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.net.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExecUtil.class);
    private static final String CMD_LINE_DELIMITER = "@@";

    public static void executeCommandLine(String commandLine) {
        try {
            if (commandLine.contains(CMD_LINE_DELIMITER)) {
                String[] cmdArray = commandLine.split(CMD_LINE_DELIMITER);
                Runtime.getRuntime().exec(cmdArray);
                logger.info("executed commandLine '{}'", Arrays.asList(cmdArray));
            } else {
                Runtime.getRuntime().exec(commandLine);
                logger.info("executed commandLine '{}'", (Object)commandLine);
            }
        }
        catch (IOException e) {
            logger.error("couldn't execute commandLine '" + commandLine + "'", (Throwable)e);
        }
    }

    public static String executeCommandLineAndWaitResponse(String commandLine, int timeout) {
        String retval = null;
        CommandLine cmdLine = null;
        if (commandLine.contains(CMD_LINE_DELIMITER)) {
            String[] cmdArray = commandLine.split(CMD_LINE_DELIMITER);
            cmdLine = new CommandLine(cmdArray[0]);
            int i = 1;
            while (i < cmdArray.length) {
                cmdLine.addArgument(cmdArray[i], false);
                ++i;
            }
        } else {
            cmdLine = CommandLine.parse((String)commandLine);
        }
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)timeout);
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)stdout);
        executor.setExitValue(1);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
            logger.debug("executed commandLine '{}'", (Object)commandLine);
        }
        catch (ExecuteException e) {
            logger.error("couldn't execute commandLine '" + commandLine + "'", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("couldn't execute commandLine '" + commandLine + "'", (Throwable)e);
        }
        try {
            resultHandler.waitFor();
            int exitCode = resultHandler.getExitValue();
            retval = StringUtils.chomp((String)stdout.toString());
            logger.debug("exit code '{}', result '{}'", (Object)exitCode, (Object)retval);
        }
        catch (InterruptedException e) {
            logger.error("Timeout occured when executing commandLine '" + commandLine + "'", (Throwable)e);
        }
        return retval;
    }
}

