/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.sitemap.internal;

import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapProviderImpl
implements SitemapProvider {
    private static final Logger logger = LoggerFactory.getLogger(SitemapProviderImpl.class);
    private ModelRepository modelRepo = null;

    public void setModelRepository(ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
    }

    public void unsetModelRepository(ModelRepository modelRepo) {
        this.modelRepo = null;
    }

    @Override
    public Sitemap getSitemap(String sitemapName) {
        if (this.modelRepo != null) {
            Sitemap sitemap = (Sitemap)this.modelRepo.getModel(String.valueOf(sitemapName) + ".sitemap");
            if (sitemap != null) {
                return sitemap;
            }
            logger.debug("Sitemap {} can not be found", (Object)sitemapName);
            return null;
        }
        logger.debug("No model repository service is available");
        return null;
    }
}

