/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.ArrayLiterals;
import org.eclipse.xtext.xbase.lib.BigDecimalExtensions;
import org.eclipse.xtext.xbase.lib.BigIntegerExtensions;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.ByteExtensions;
import org.eclipse.xtext.xbase.lib.CharacterExtensions;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ComparableExtensions;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.FloatExtensions;
import org.eclipse.xtext.xbase.lib.FunctionExtensions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.LongExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.ProcedureExtensions;
import org.eclipse.xtext.xbase.lib.ShortExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@ImplementedBy(value=ImplicitlyImportedTypes.class)
public class ImplicitlyImportedFeatures {
    @Inject
    private TypeReferences typeReferences;

    public List<JvmType> getStaticImportClasses(Resource context) {
        List<Class<?>> classes = this.getStaticImportClasses();
        return this.getTypes(classes, context);
    }

    public List<JvmType> getExtensionClasses(Resource context) {
        List<Class<?>> classes = this.getExtensionClasses();
        return this.getTypes(classes, context);
    }

    protected List<JvmType> getTypes(List<Class<?>> classes, Resource context) {
        ArrayList result = Lists.newArrayListWithCapacity((int)classes.size());
        for (Class<?> clazz : classes) {
            JvmType type = this.typeReferences.findDeclaredType(clazz, (Notifier)context);
            if (type == null) continue;
            result.add(type);
        }
        return result;
    }

    protected List<Class<?>> getStaticImportClasses() {
        return Lists.newArrayList((Object[])new Class[]{ArrayLiterals.class, CollectionLiterals.class, InputOutput.class});
    }

    protected List<Class<?>> getExtensionClasses() {
        return Lists.newArrayList((Object[])new Class[]{ArrayExtensions.class, BigDecimalExtensions.class, BigIntegerExtensions.class, BooleanExtensions.class, ByteExtensions.class, CharacterExtensions.class, CollectionExtensions.class, ComparableExtensions.class, DoubleExtensions.class, FloatExtensions.class, FunctionExtensions.class, IntegerExtensions.class, IterableExtensions.class, IteratorExtensions.class, ListExtensions.class, LongExtensions.class, MapExtensions.class, ObjectExtensions.class, ProcedureExtensions.class, ShortExtensions.class, StringExtensions.class});
    }
}

