/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.DefaultAbstractManagedProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedThingProvider
extends DefaultAbstractManagedProvider<Thing, ThingUID>
implements ThingProvider {
    private static final Logger logger = LoggerFactory.getLogger(ManagedThingProvider.class);
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();

    public Thing createThing(ThingTypeUID thingTypeUID, ThingUID thingUID, ThingUID bridgeUID, Configuration configuration) {
        logger.debug("Creating thing for type '{}'.", (Object)thingTypeUID);
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            if (!thingHandlerFactory.supportsThingType(thingTypeUID)) continue;
            Thing thing = thingHandlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
            this.add(thing);
            return thing;
        }
        logger.warn("Cannot create thing. No binding found that supports creating a thing of type {}.", (Object)thingTypeUID);
        return null;
    }

    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.add(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    protected ThingUID getKey(Thing thing) {
        return thing.getUID();
    }

    protected String getStorageName() {
        return Thing.class.getName();
    }

    protected String keyToString(ThingUID key) {
        return key.toString();
    }
}

