/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import com.google.common.base.Joiner;
import java.util.Arrays;

public abstract class UID {
    private static final String SEPARATOR = ":";
    private final String[] segments;

    public UID(String uid) {
        this(UID.splitToSegments(uid));
    }

    private static String[] splitToSegments(String uid) {
        if (uid == null) {
            throw new IllegalArgumentException("Given uid must not be null.");
        }
        return uid.split(SEPARATOR);
    }

    public UID(String ... segments) {
        if (segments == null) {
            throw new IllegalArgumentException("Given segments argument must not be null.");
        }
        int numberOfSegments = this.getMinimalNumberOfSegments();
        if (segments.length < numberOfSegments) {
            throw new IllegalArgumentException("UID must have at least " + numberOfSegments + " segments.");
        }
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!segment.matches("[A-Za-z0-9_-]*")) {
                throw new IllegalArgumentException("UID segment '" + segment + "' contains invalid characters. Each segment of the UID must match the pattern [A-Za-z0-9_-]*.");
            }
            ++n2;
        }
        this.segments = segments;
    }

    protected abstract int getMinimalNumberOfSegments();

    protected String[] getSegments() {
        return this.segments;
    }

    protected String getSegment(int segment) {
        return this.segments[segment];
    }

    public String getBindingId() {
        return this.segments[0];
    }

    public String toString() {
        return Joiner.on((String)SEPARATOR).join((Object[])this.segments);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.segments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UID other = (UID)obj;
        return Arrays.equals(this.segments, other.segments);
    }
}

