/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ThingTypeChangeListener;
import org.eclipse.smarthome.core.thing.binding.ThingTypeProvider;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingTypeRegistry
implements ThingTypeChangeListener {
    private Logger logger = LoggerFactory.getLogger((String)ThingTypeRegistry.class.getName());
    private Map<ThingTypeProvider, Collection<ThingType>> thingTypeMap = new ConcurrentHashMap<ThingTypeProvider, Collection<ThingType>>();

    public List<ThingType> getThingTypes() {
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)Iterables.concat(this.thingTypeMap.values())));
    }

    public List<ThingType> getThingTypes(String bindingId) {
        ArrayList thingTypesForBinding = Lists.newArrayList();
        for (ThingType thingType : this.getThingTypes()) {
            if (!thingType.getBindingId().equals(bindingId)) continue;
            thingTypesForBinding.add(thingType);
        }
        return thingTypesForBinding;
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID) {
        for (ThingType thingType : this.getThingTypes()) {
            if (!thingType.getUID().equals(thingTypeUID)) continue;
            return thingType;
        }
        return null;
    }

    @Override
    public void thingTypeAdded(ThingTypeProvider provider, ThingType thingType) {
        Collection<ThingType> thingTypes = this.thingTypeMap.get(provider);
        if (thingTypes != null) {
            thingTypes.add(thingType);
        }
    }

    @Override
    public void thingTypeRemoved(ThingTypeProvider provider, ThingType thingType) {
        Collection<ThingType> thingTypes = this.thingTypeMap.get(provider);
        if (thingTypes != null) {
            thingTypes.remove(thingType);
        }
    }

    protected void addThingTypeProvider(ThingTypeProvider thingTypeProvider) {
        if (!this.thingTypeMap.containsKey(thingTypeProvider)) {
            CopyOnWriteArraySet<ThingType> thingTypes = new CopyOnWriteArraySet<ThingType>(thingTypeProvider.getThingTypes());
            thingTypeProvider.addThingTypeChangeListener(this);
            this.thingTypeMap.put(thingTypeProvider, thingTypes);
            this.logger.debug("Thing type provider '{}' has been added.", (Object)thingTypeProvider.getClass().getName());
        }
    }

    protected void removeThingTypeProvider(ThingTypeProvider thingTypeProvider) {
        if (this.thingTypeMap.containsKey(thingTypeProvider)) {
            this.thingTypeMap.remove(thingTypeProvider);
            thingTypeProvider.removeThingTypeChangeListener(this);
            this.logger.debug("Thing type provider '{}' has been removed.", (Object)thingTypeProvider.getClass().getName());
        }
    }
}

