/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtBasedTypeFactory;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeMirror;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.util.Strings;

public class JdtTypeProvider
extends AbstractJvmTypeProvider
implements IJdtTypeProvider {
    private static final Logger LOG = Logger.getLogger(JdtTypeProvider.class);
    private static final String PRIMITIVES = URIHelperConstants.PRIMITIVES_URI.segment(0);
    private final IJavaProject javaProject;
    private final TypeURIHelper typeUriHelper;
    private final JdtBasedTypeFactory typeFactory;
    private final WorkingCopyOwner workingCopyOwner;

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet) {
        this(javaProject, resourceSet, null);
    }

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        this(javaProject, resourceSet, indexedJvmTypeAccess, null);
    }

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess, WorkingCopyOwner workingCopyOwner) {
        super(resourceSet, indexedJvmTypeAccess);
        if (javaProject == null) {
            throw new IllegalArgumentException("javaProject may not be null");
        }
        this.javaProject = javaProject;
        this.typeUriHelper = this.createTypeURIHelper();
        this.workingCopyOwner = workingCopyOwner;
        this.typeFactory = this.createTypeFactory();
    }

    protected JdtBasedTypeFactory createTypeFactory() {
        return new JdtBasedTypeFactory(this.typeUriHelper, this.workingCopyOwner);
    }

    protected TypeURIHelper createTypeURIHelper() {
        return new TypeURIHelper();
    }

    public JvmType findTypeByName(String name) {
        String signature = this.getSignature(name);
        if (signature == null) {
            return null;
        }
        URI resourceURI = this.typeUriHelper.createResourceURI(signature);
        if (resourceURI.segment(0) == PRIMITIVES) {
            return this.findPrimitiveType(signature, resourceURI);
        }
        return this.findObjectType(signature, resourceURI);
    }

    public JvmType findTypeByName(String name, boolean binaryNestedTypeDelimiter) {
        JvmType result = this.findTypeByName(name);
        if (result != null || this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter)) {
            return result;
        }
        AbstractJvmTypeProvider.ClassNameVariants nameVariants = new AbstractJvmTypeProvider.ClassNameVariants(name);
        while (result == null && nameVariants.hasNext()) {
            String nextVariant = (String)nameVariants.next();
            result = this.findTypeByName(nextVariant);
        }
        return result;
    }

    private String getSignature(String name) {
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("null");
        }
        String signature = null;
        try {
            signature = name.startsWith("[") ? name : Signature.createTypeSignature((String)name, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return signature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JvmType findObjectType(String signature, URI resourceURI) {
        TypeResource resource = this.getLoadedResourceForJavaURI(resourceURI);
        try {
            JvmType result = this.findLoadedOrDerivedObjectType(signature, resourceURI, resource);
            if (result != null || resource != null) {
                if (result != null && !this.canLink(result.getQualifiedName())) {
                    return null;
                }
                return result;
            }
            try {
                return this.findObjectTypeInJavaProject(signature, resourceURI);
            }
            catch (JavaModelException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        catch (IndexedJvmTypeAccess.ShadowedTypeException e) {
            return null;
        }
    }

    private JvmType findLoadedOrDerivedObjectType(String signature, URI resourceURI, TypeResource resource) {
        JvmType result;
        JvmType jvmType = result = resource != null ? this.findTypeBySignature(signature, resource) : null;
        if (result != null) {
            return result;
        }
        result = this.findObjectTypeInIndex(signature, resourceURI);
        if (result != null) {
            return result;
        }
        return null;
    }

    private JvmType findObjectTypeInJavaProject(String signature, URI resourceURI) throws JavaModelException {
        IType type = this.findObjectTypeInJavaProject(resourceURI);
        if (type != null) {
            try {
                return this.createResourceAndFindType(resourceURI, type, signature);
            }
            catch (IOException ioe) {
                return null;
            }
            catch (WrappedException wrapped) {
                if (wrapped.getCause() instanceof IOException) {
                    return null;
                }
                throw wrapped;
            }
        }
        return null;
    }

    private JvmType createResourceAndFindType(URI resourceURI, IType type, String signature) throws IOException {
        TypeResource resource = this.createResource(resourceURI, type);
        resource.load(null);
        return this.findTypeBySignature(signature, resource);
    }

    private TypeResource createResource(URI resourceURI, IType type) {
        TypeResource resource = new TypeResource(resourceURI);
        resource.setIndexedJvmTypeAccess(this.getIndexedJvmTypeAccess());
        this.getResourceSet().getResources().add((Object)resource);
        if (type.exists()) {
            IMirror mirror = this.createMirror(type);
            resource.setMirror(mirror);
        }
        return resource;
    }

    private IType findObjectTypeInJavaProject(URI resourceURI) throws JavaModelException {
        IType type;
        String topLevelType = resourceURI.segment(resourceURI.segmentCount() - 1);
        int lastDot = topLevelType.lastIndexOf(46);
        String packageName = null;
        String typeName = topLevelType;
        if (lastDot != -1) {
            typeName = typeName.substring(lastDot + 1);
            packageName = topLevelType.substring(0, lastDot);
        }
        if ((type = this.javaProject.findType(packageName, typeName)) != null && !this.canLink(type.getFullyQualifiedName())) {
            return null;
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canLink(String typeName) {
        if (typeName == null) {
            return false;
        }
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        if (indexedJvmTypeAccess == null || !indexedJvmTypeAccess.isIndexingPhase((Notifier)this.getResourceSet())) return true;
        try {
            IType type = this.javaProject.findType(typeName);
            if (type == null || !type.exists()) return false;
            IResource underlyingResource = type.getUnderlyingResource();
            if (underlyingResource == null) {
                return true;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (true) {
                IResource srcUnderlyingResource;
                if (n2 >= n) {
                    return true;
                }
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1 && (srcUnderlyingResource = root.getUnderlyingResource()) != null && srcUnderlyingResource.contains((ISchedulingRule)underlyingResource)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private JvmType findObjectTypeInIndex(String signature, URI resourceURI) {
        URI proxyURI;
        EObject candidate;
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        if (indexedJvmTypeAccess != null && (candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI = resourceURI.appendFragment(this.typeUriHelper.getFragment(signature)), this.getResourceSet(), true)) instanceof JvmType) {
            return (JvmType)candidate;
        }
        return null;
    }

    private TypeResource getLoadedResourceForJavaURI(URI resourceURI) {
        TypeResource resource = (TypeResource)this.getResourceForJavaURI(resourceURI, false);
        return resource;
    }

    private JvmType findPrimitiveType(String signature, URI resourceURI) {
        TypeResource resource = (TypeResource)this.getResourceForJavaURI(resourceURI, true);
        JvmType result = this.findTypeBySignature(signature, resource);
        return result;
    }

    protected Resource getResourceForJavaURI(URI resourceURI, boolean loadOnDemand) {
        return this.getResourceSet().getResource(resourceURI, loadOnDemand);
    }

    public JvmType findTypeBySignature(String signature, TypeResource resource) {
        String fragment = this.typeUriHelper.getFragment(signature);
        return (JvmType)resource.getEObject(fragment);
    }

    protected IMirror createMirrorForFQN(String name) {
        IType type;
        block3: {
            try {
                type = this.javaProject.findType(name);
                if (type != null && type.exists()) break block3;
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return this.createMirror(type);
    }

    private IMirror createMirror(IType type) {
        String elementName = type.getElementName();
        if (!elementName.equals(type.getTypeQualifiedName())) {
            return null;
        }
        return new JdtTypeMirror(type, this.typeFactory);
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public TypeURIHelper getTypeUriHelper() {
        return this.typeUriHelper;
    }

    public JdtBasedTypeFactory getJdtBasedTypeFactory() {
        return this.typeFactory;
    }
}

