/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.autoupdate.AutoUpdateBindingConfigProvider;
import org.eclipse.smarthome.model.item.BindingConfigParseException;
import org.eclipse.smarthome.model.item.BindingConfigReader;

public class AutoUpdateGenericBindingConfigProvider
implements AutoUpdateBindingConfigProvider,
BindingConfigReader {
    protected Map<String, AutoUpdateBindingConfig> bindingConfigs = new ConcurrentHashMap<String, AutoUpdateBindingConfig>(new WeakHashMap());
    protected Map<String, Set<String>> contextMap = new ConcurrentHashMap<String, Set<String>>();

    @Override
    public String getBindingType() {
        return "autoupdate";
    }

    @Override
    public void validateItemType(String itemType, String bindingConfig) throws BindingConfigParseException {
    }

    @Override
    public void processBindingConfiguration(String context, String itemType, String itemName, String bindingConfig) throws BindingConfigParseException {
        Set<String> itemNames = this.contextMap.get(context);
        if (itemNames == null) {
            itemNames = new HashSet<String>();
            this.contextMap.put(context, itemNames);
        }
        itemNames.add(itemName);
        AutoUpdateBindingConfig config = new AutoUpdateBindingConfig();
        this.parseBindingConfig(bindingConfig, config);
        this.addBindingConfig(itemType, itemName, config);
    }

    protected void parseBindingConfig(String bindingConfig, AutoUpdateBindingConfig config) throws BindingConfigParseException {
        if (StringUtils.isNotBlank((String)bindingConfig)) {
            try {
                config.autoupdate = Boolean.valueOf(bindingConfig.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BindingConfigParseException("The given parameter '" + bindingConfig.trim() + "' has to be set to either 'true' or 'false'.");
            }
        }
    }

    public Boolean autoUpdate(String itemName) {
        AutoUpdateBindingConfig config = this.bindingConfigs.get(itemName);
        return config != null ? Boolean.valueOf(config.autoupdate) : null;
    }

    @Override
    public void removeConfigurations(String context) {
        Set<String> itemNames = this.contextMap.get(context);
        if (itemNames != null) {
            for (String itemName : itemNames) {
                this.bindingConfigs.remove(itemName);
            }
            this.contextMap.remove(context);
        }
    }

    protected void addBindingConfig(String itemType, String itemName, AutoUpdateBindingConfig config) {
        this.bindingConfigs.put(itemName, config);
    }

    public boolean providesBindingFor(String itemName) {
        return this.bindingConfigs.get(itemName) != null;
    }

    public boolean providesBinding() {
        return !this.bindingConfigs.isEmpty();
    }

    public Collection<String> getItemNames() {
        return new ArrayList<String>(this.bindingConfigs.keySet());
    }

    static class AutoUpdateBindingConfig {
        boolean autoupdate;

        AutoUpdateBindingConfig() {
        }
    }
}

