/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.impl.ConcreteSyntaxEValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceValidatorImpl
implements IResourceValidator {
    private static final Logger log = Logger.getLogger(ResourceValidatorImpl.class);
    @Inject
    private Diagnostician diagnostician;
    @Inject
    private IDiagnosticConverter converter;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator mon) {
        task = Stopwatches.forTask((String)"ResourceValidatorImpl.validation");
        try {
            block16: {
                task.start();
                monitor = mon == null ? CancelIndicator.NullImpl : mon;
                this.resolveProxies(resource, monitor);
                if (monitor.isCanceled()) {
                    var10_6 = Collections.emptyList();
                    return var10_6;
                }
                result = Lists.newArrayListWithExpectedSize((int)(resource.getErrors().size() + resource.getWarnings().size()));
                try {
                    acceptor = this.createAcceptor(result);
                    if (!mode.shouldCheck(CheckType.FAST)) break block16;
                    i = 0;
                    if (true) ** GOTO lbl23
                }
                catch (RuntimeException e) {
                    ResourceValidatorImpl.log.error((Object)e.getMessage(), (Throwable)e);
                    while (true) {
                        var10_11 = result;
                        return var10_11;
                    }
                }
                do {
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getErrors().get(i), Severity.ERROR, acceptor);
                    ++i;
lbl23:
                    // 2 sources

                    if (i < resource.getErrors().size()) continue;
                    i = 0;
                    if (true) ** GOTO lbl35
                } while (!monitor.isCanceled());
                var10_7 = Collections.emptyList();
                return var10_7;
                do {
                    if (monitor.isCanceled()) {
                        var10_8 = Collections.emptyList();
                        return var10_8;
                    }
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getWarnings().get(i), Severity.WARNING, acceptor);
                    ++i;
lbl35:
                    // 2 sources

                } while (i < resource.getWarnings().size());
            }
            if (monitor.isCanceled()) {
                var10_9 = Collections.emptyList();
                return var10_9;
            }
            syntaxDiagFail = result.isEmpty() == false;
            this.logCheckStatus(resource, syntaxDiagFail, "Syntax");
            this.validate(resource, mode, monitor, acceptor);
            if (!monitor.isCanceled()) ** continue;
            var10_10 = Collections.emptyList();
            return var10_10;
        }
        finally {
            task.stop();
        }
    }

    protected void validate(Resource resource, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        for (EObject ele : resource.getContents()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.validate(resource, ele, mode, monitor, acceptor);
        }
    }

    protected void validate(Resource resource, EObject element, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        try {
            Diagnostic diagnostic;
            HashMap options = Maps.newHashMap();
            options.put("check.mode", mode);
            options.put(CancelableDiagnostician.CANCEL_INDICATOR, monitor);
            options.put(ConcreteSyntaxEValidator.DISABLE_CONCRETE_SYNTAX_EVALIDATOR, Boolean.TRUE);
            options.put(EValidator.class, this.diagnostician);
            if (resource instanceof XtextResource) {
                options.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ((XtextResource)resource).getLanguageName());
            }
            if (!(diagnostic = this.diagnostician.validate(element, (Map)options)).getChildren().isEmpty()) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
                }
            } else {
                this.issueFromEValidatorDiagnostic(diagnostic, acceptor);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void resolveProxies(Resource resource, CancelIndicator monitor) {
        EcoreUtil2.resolveLazyCrossReferences(resource, monitor);
    }

    protected IAcceptor<Issue> createAcceptor(List<Issue> result) {
        return new ListBasedMarkerAcceptor(result);
    }

    private void logCheckStatus(Resource resource, boolean parserDiagFail, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(string) + " check " + (parserDiagFail ? "FAIL" : "OK") + "! Resource: " + resource.getURI()));
        }
    }

    protected void issueFromXtextResourceDiagnostic(Resource.Diagnostic diagnostic, Severity severity, IAcceptor<Issue> acceptor) {
        this.converter.convertResourceDiagnostic(diagnostic, severity, acceptor);
    }

    protected void issueFromEValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
        this.converter.convertValidatorDiagnostic(diagnostic, acceptor);
    }

    public void setDiagnostician(Diagnostician diagnostician) {
        this.diagnostician = diagnostician;
    }

    public Diagnostician getDiagnostician() {
        return this.diagnostician;
    }

    public void setDiagnosticConverter(IDiagnosticConverter converter) {
        this.converter = converter;
    }

    public IDiagnosticConverter getDiagnosticConverter() {
        return this.converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ListBasedMarkerAcceptor
    implements IAcceptor<Issue> {
        private final List<Issue> result;

        protected ListBasedMarkerAcceptor(List<Issue> result) {
            this.result = result;
        }

        public void accept(Issue issue) {
            if (issue != null) {
                this.result.add(issue);
            }
        }
    }
}

