/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.ui.contentassist;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.designer.ui.UIActivator;
import org.eclipse.smarthome.model.ui.contentassist.AbstractItemsProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class ItemsProposalProvider
extends AbstractItemsProposalProvider {
    protected static final Set<String> ITEMTYPES = CollectionLiterals.newHashSet((Object[])new String[]{"Group", "Switch", "Number", "String", "Dimmer", "Color", "Contact", "Rollershutter", "DateTime"});

    @Override
    public void completeModelNormalItem_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeModelNormalItem_Type(model, assignment, context, acceptor);
        for (String itemType : ITEMTYPES) {
            String _prefix;
            boolean _startsWith = itemType.startsWith(_prefix = context.getPrefix());
            if (!_startsWith) continue;
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(itemType, context);
            acceptor.accept(_createCompletionProposal);
        }
    }

    @Override
    public void completeModelItem_Groups(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        ItemRegistry _service;
        super.completeModelItem_Groups(model, assignment, context, acceptor);
        ItemRegistry registry = _service = (ItemRegistry)UIActivator.itemRegistryTracker.getService();
        boolean bl = _notEquals = !Objects.equal((Object)registry, null);
        if (_notEquals) {
            String _prefix = context.getPrefix();
            String _plus = String.valueOf(_prefix) + "*";
            Collection _items = registry.getItems(_plus);
            for (Item item : _items) {
                if (!(item instanceof GroupItem)) continue;
                String _name = ((GroupItem)item).getName();
                ICompletionProposal completionProposal = this.createCompletionProposal(_name, context);
                acceptor.accept(completionProposal);
            }
        }
    }
}

