/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.smarthome.model.items.ModelBinding;
import org.eclipse.smarthome.model.items.ModelGroupItem;
import org.eclipse.smarthome.model.items.ModelItem;
import org.eclipse.smarthome.model.items.ModelNormalItem;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class ItemsLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public ItemsLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected String text(ModelItem item) {
        if (item instanceof ModelGroupItem) {
            String _name = ((ModelGroupItem)item).getName();
            return "Group " + _name;
        }
        if (item instanceof ModelNormalItem) {
            String name = ((ModelNormalItem)item).getName();
            String _type = ((ModelNormalItem)item).getType();
            String _plus = String.valueOf(_type) + " ";
            return String.valueOf(_plus) + name;
        }
        return item.getLabel();
    }

    protected String text(ModelBinding binding) {
        return binding.getType();
    }

    protected String image(ModelItem item) {
        if (item instanceof ModelGroupItem) {
            return "group.png";
        }
        if (item instanceof ModelNormalItem) {
            String _type = ((ModelNormalItem)item).getType();
            String _lowerCase = _type.toLowerCase();
            return String.valueOf(_lowerCase) + ".png";
        }
        return null;
    }

    protected String image(ModelBinding binding) {
        return "binding.png";
    }
}

