/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.ant.internal.ui.views.actions.SearchForBuildFilesDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SearchForBuildFilesAction
extends Action {
    private AntView view;

    public SearchForBuildFilesAction(AntView view) {
        super(AntViewActionMessages.SearchForBuildFilesAction_Search_1, AntUIImages.getImageDescriptor("org.eclipse.ant.ui.search"));
        this.setToolTipText(AntViewActionMessages.SearchForBuildFilesAction_Add_build_files_with_search_2);
        this.view = view;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ant.ui.search_for_buildfiles_action_context");
    }

    public void run() {
        SearchForBuildFilesDialog dialog = new SearchForBuildFilesDialog();
        if (dialog.open() != 1) {
            final IFile[] files = dialog.getResults();
            final boolean includeErrorNodes = dialog.getIncludeErrorResults();
            final AntProjectNode[] existingProjects = this.view.getProjects();
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(AntViewActionMessages.SearchForBuildFilesAction_Processing_search_results_3, files.length);
                        int i = 0;
                        while (i < files.length && !monitor.isCanceled()) {
                            String buildFileName = files[i].getFullPath().toString();
                            monitor.subTask(MessageFormat.format((String)AntViewActionMessages.SearchForBuildFilesAction_Adding__0__4, (Object[])new Object[]{buildFileName}));
                            if (!this.alreadyAdded(buildFileName)) {
                                final AntProjectNodeProxy project = new AntProjectNodeProxy(buildFileName);
                                project.parseBuildFile();
                                monitor.worked(1);
                                if (includeErrorNodes || !project.isErrorNode()) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            SearchForBuildFilesAction.this.view.addProject(project);
                                        }
                                    });
                                }
                            }
                            ++i;
                        }
                    }

                    private boolean alreadyAdded(String buildFileName) {
                        int j = 0;
                        while (j < existingProjects.length) {
                            AntProjectNode existingProject = existingProjects[j];
                            if (existingProject.getBuildFileName().equals(buildFileName)) {
                                return true;
                            }
                            ++j;
                        }
                        return false;
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

