/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.ui.internal.views;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.smarthome.designer.core.config.ConfigurationFolderProvider;
import org.eclipse.smarthome.designer.ui.internal.views.ConfigNavigatorActionGroup;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.CommonNavigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNavigator
extends CommonNavigator {
    private IResourceChangeListener changeListener;
    private static final Logger logger = LoggerFactory.getLogger(ConfigNavigator.class);

    protected Object getInitialInput() {
        this.changeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConfigNavigator.this.getCommonViewer().refresh();
                    }
                });
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.changeListener);
        try {
            IFolder rootConfigurationFolder = ConfigurationFolderProvider.getRootConfigurationFolder();
            if (rootConfigurationFolder != null) {
                return rootConfigurationFolder.getProject();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("An error occurred while reading config project", (Throwable)e);
            return null;
        }
    }

    protected ActionGroup createCommonActionGroup() {
        return new ConfigNavigatorActionGroup(this.getCommonViewer());
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.changeListener);
        this.changeListener = null;
    }
}

