/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;

public class DateTimeType
implements PrimitiveType,
State,
Command {
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected Calendar calendar;

    public DateTimeType() {
        this(Calendar.getInstance());
    }

    public DateTimeType(Calendar calendar) {
        this.calendar = calendar;
    }

    public DateTimeType(String calendarValue) {
        Date date = null;
        try {
            date = DATE_FORMATTER.parse(calendarValue);
        }
        catch (ParseException fpe) {
            throw new IllegalArgumentException(String.valueOf(calendarValue) + " is not in a valid format.", fpe);
        }
        if (date != null) {
            this.calendar = Calendar.getInstance();
            this.calendar.setTime(date);
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public static DateTimeType valueOf(String value) {
        return new DateTimeType(value);
    }

    public String format(String pattern) {
        try {
            return String.format(pattern, this.calendar);
        }
        catch (NullPointerException nullPointerException) {
            return DATE_FORMATTER.format(this.calendar.getTime());
        }
    }

    public String format(Locale locale, String pattern) {
        return String.format(locale, pattern, this.calendar);
    }

    public String toString() {
        return DATE_FORMATTER.format(this.calendar.getTime());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeType other = (DateTimeType)obj;
        return !(this.calendar == null ? other.calendar != null : !this.calendar.equals(other.calendar));
    }
}

