/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import org.eclipse.smarthome.core.library.types.DecimalType;

public class PercentType
extends DecimalType {
    private static final long serialVersionUID = -9066279845951780879L;
    public static final PercentType ZERO = new PercentType(0);
    public static final PercentType HUNDRED = new PercentType(100);

    public PercentType() {
    }

    public PercentType(int value) {
        super(value);
        this.validateValue(this.value);
    }

    public PercentType(String value) {
        super(value);
        this.validateValue(this.value);
    }

    public PercentType(BigDecimal value) {
        super(value);
        this.validateValue(this.value);
    }

    private void validateValue(BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(value) > 0 || new BigDecimal(100).compareTo(value) < 0) {
            throw new IllegalArgumentException("Value must be between 0 and 100");
        }
    }

    public static PercentType valueOf(String value) {
        return new PercentType(value);
    }

    public static /* bridge */ /* synthetic */ DecimalType valueOf(String string) {
        return PercentType.valueOf(string);
    }
}

