/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.autoupdate.internal;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.core.autoupdate.AutoUpdateBindingConfigProvider;
import org.eclipse.smarthome.core.events.AbstractEventSubscriber;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdateBinding
extends AbstractEventSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(AutoUpdateBinding.class);
    protected ItemRegistry itemRegistry;
    protected Collection<AutoUpdateBindingConfigProvider> providers = new CopyOnWriteArraySet<AutoUpdateBindingConfigProvider>();
    protected EventPublisher eventPublisher = null;

    public void addBindingConfigProvider(AutoUpdateBindingConfigProvider provider) {
        this.providers.add(provider);
    }

    public void removeBindingConfigProvider(AutoUpdateBindingConfigProvider provider) {
        this.providers.remove(provider);
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public void receiveCommand(String itemName, Command command) {
        Boolean autoUpdate = null;
        for (AutoUpdateBindingConfigProvider provider : this.providers) {
            Boolean au = provider.autoUpdate(itemName);
            if (au != null && Boolean.TRUE.equals(autoUpdate = au)) break;
        }
        if (autoUpdate == null) {
            autoUpdate = Boolean.TRUE;
        }
        if (autoUpdate.booleanValue() && command instanceof State) {
            this.postUpdate(itemName, (State)command);
        } else {
            logger.trace("Won't update item '{}' as it is not configured to update its state automatically.", (Object)itemName);
        }
    }

    private void postUpdate(String itemName, State newState) {
        if (this.itemRegistry != null) {
            try {
                GenericItem item = (GenericItem)this.itemRegistry.getItem(itemName);
                boolean isAccepted = false;
                if (item.getAcceptedDataTypes().contains(newState.getClass())) {
                    isAccepted = true;
                } else {
                    for (Class state : item.getAcceptedDataTypes()) {
                        try {
                            if (state.isEnum() || !((State)state.newInstance()).getClass().isAssignableFrom(newState.getClass())) continue;
                            isAccepted = true;
                            break;
                        }
                        catch (InstantiationException e) {
                            logger.warn("InstantiationException on ", (Object)e.getMessage());
                        }
                        catch (IllegalAccessException e) {
                            logger.warn("IllegalAccessException on ", (Object)e.getMessage());
                        }
                    }
                }
                if (isAccepted) {
                    this.eventPublisher.postUpdate(itemName, newState, "org.eclipse.smarthome.core.autoupdate");
                } else {
                    logger.debug("Received update of a not accepted type (" + newState.getClass().getSimpleName() + ") for item " + itemName);
                }
            }
            catch (ItemNotFoundException e) {
                logger.debug("Received update for non-existing item: {}", (Object)e.getMessage());
            }
        }
    }
}

