/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;

public abstract class AbstractEditStrategy
implements IAutoEditStrategy,
VerifyKeyListener {
    private static final Logger log = Logger.getLogger(AbstractEditStrategy.class);
    public static final String DEBUG = "org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy.DEBUG";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy.DEBUG")
    protected boolean debug = false;
    private boolean skipNext = false;

    private boolean shouldSkipNext(int keyCode) {
        IKeyLookup lookUp = KeyLookupFactory.getDefault();
        return lookUp.getCommand() == keyCode || lookUp.getCtrl() == keyCode;
    }

    public void verifyKey(VerifyEvent event) {
        this.skipNext = this.shouldSkipNext(event.keyCode);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (this.skipNext) {
            return;
        }
        try {
            this.internalCustomizeDocumentCommand(document, command);
        }
        catch (BadLocationException e) {
            this.handleBadLocationException(e);
        }
    }

    protected void handleBadLocationException(BadLocationException e) {
        log.error((Object)e.getMessage(), (Throwable)e);
        if (this.debug) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void internalCustomizeDocumentCommand(IDocument var1, DocumentCommand var2) throws BadLocationException;

    public int count(String toFind, String searchMe) throws BadLocationException {
        int count = 0;
        int index = -toFind.length();
        while ((index = searchMe.indexOf(toFind, index + toFind.length())) != -1) {
            ++count;
        }
        return count;
    }

    protected String getDocumentContent(IDocument document, DocumentCommand command) throws BadLocationException {
        final ITypedRegion partition = document.getPartition(command.offset);
        ITypedRegion[] partitions = document.getDocumentPartitioner().computePartitioning(0, document.getLength());
        Iterable partitionsOfCurrentType = Iterables.filter(Arrays.asList(partitions), (Predicate)new Predicate<ITypedRegion>(){

            public boolean apply(ITypedRegion input) {
                return input.getType().equals(partition.getType());
            }
        });
        StringBuilder builder = new StringBuilder();
        for (ITypedRegion position : partitionsOfCurrentType) {
            builder.append(document.get(position.getOffset(), position.getLength()));
        }
        return builder.toString();
    }

    protected boolean isIdentifierPart(IDocument doc, int offset) throws BadLocationException {
        if (doc.getLength() <= offset) {
            return false;
        }
        try {
            char c = doc.getChar(offset);
            return Character.isJavaIdentifierPart(c);
        }
        catch (BadLocationException e) {
            this.handleBadLocationException(e);
            return false;
        }
    }
}

