/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.occurrences;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.SimpleLocalResourceAccess;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.occurrences.IOccurrenceComputer;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOccurrenceComputer
implements IOccurrenceComputer {
    private static Logger LOG = Logger.getLogger(DefaultOccurrenceComputer.class);
    public static final String OCCURRENCE_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.defaultOccurrenceAnnotation";
    public static final String DECLARATION_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.declarationAnnotation";
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    protected void addOccurrenceAnnotation(String type, IDocument document, ITextRegion textRegion, Map<Annotation, Position> annotationMap) {
        try {
            if (textRegion != null && textRegion.getLength() > 0) {
                Annotation annotation = new Annotation(type, false, document.get(textRegion.getOffset(), textRegion.getLength()));
                annotationMap.put(annotation, new Position(textRegion.getOffset(), textRegion.getLength()));
            }
        }
        catch (BadLocationException e) {
            LOG.error((Object)"Error creating occurrence annotation", (Throwable)e);
        }
    }

    @Override
    public Map<Annotation, Position> createAnnotationMap(XtextEditor editor, final ITextSelection selection, final SubMonitor monitor) {
        final IXtextDocument document = editor.getDocument();
        if (document != null) {
            return (Map)document.readOnly((IUnitOfWork)new IUnitOfWork<Map<Annotation, Position>, XtextResource>(){

                public Map<Annotation, Position> exec(XtextResource resource) throws Exception {
                    EObject target;
                    if (resource != null && (target = DefaultOccurrenceComputer.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset())) != null && !target.eIsProxy()) {
                        monitor.setWorkRemaining(100);
                        final ArrayList references = Lists.newArrayList();
                        IAcceptor<IReferenceDescription> acceptor = new IAcceptor<IReferenceDescription>(){

                            public void accept(IReferenceDescription reference) {
                                references.add(reference);
                            }
                        };
                        SimpleLocalResourceAccess localResourceAccess = new SimpleLocalResourceAccess(resource.getResourceSet());
                        DefaultOccurrenceComputer.this.referenceFinder.findReferences(DefaultOccurrenceComputer.this.getTargetURIs(target), Collections.singleton(resource.getURI()), localResourceAccess, acceptor, (IProgressMonitor)monitor.newChild(40));
                        if (monitor.isCanceled()) {
                            return Collections.emptyMap();
                        }
                        HashMap result = Maps.newHashMapWithExpectedSize((int)(references.size() + 1));
                        if (target.eResource() == resource && (!references.isEmpty() || DefaultOccurrenceComputer.this.canBeReferencedLocally(target))) {
                            ITextRegion declarationRegion = DefaultOccurrenceComputer.this.locationInFileProvider.getSignificantTextRegion(target);
                            DefaultOccurrenceComputer.this.addOccurrenceAnnotation(DefaultOccurrenceComputer.DECLARATION_ANNOTATION_TYPE, document, declarationRegion, result);
                        }
                        monitor.worked(5);
                        for (IReferenceDescription reference : references) {
                            try {
                                EObject source = resource.getEObject(reference.getSourceEObjectUri().fragment());
                                if (source == null || reference.getEReference() == null) continue;
                                ITextRegion textRegion = DefaultOccurrenceComputer.this.locationInFileProvider.getSignificantTextRegion(source, (EStructuralFeature)reference.getEReference(), reference.getIndexInList());
                                DefaultOccurrenceComputer.this.addOccurrenceAnnotation(DefaultOccurrenceComputer.OCCURRENCE_ANNOTATION_TYPE, document, textRegion, result);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        monitor.worked(15);
                        return result;
                    }
                    return Collections.emptyMap();
                }
            });
        }
        return Collections.emptyMap();
    }

    protected Iterable<URI> getTargetURIs(EObject target) {
        return Collections.singleton(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)target));
    }

    protected boolean canBeReferencedLocally(EObject object) {
        boolean result = this.qualifiedNameProvider.getFullyQualifiedName(object) != null;
        return result;
    }

    @Override
    public boolean hasAnnotationType(String annotationType) {
        return DECLARATION_ANNOTATION_TYPE.equals(annotationType) || OCCURRENCE_ANNOTATION_TYPE.equals(annotationType);
    }
}

