/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;

public class ConfigDescription {
    private URI uri;
    private List<ConfigDescriptionParameter> parameters;

    public ConfigDescription(URI uri) throws IllegalArgumentException {
        this(uri, null);
    }

    public ConfigDescription(URI uri, List<ConfigDescriptionParameter> parameters) {
        if (uri == null) {
            throw new IllegalArgumentException("The URI must not be null!");
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("The scheme is missing!");
        }
        if (!uri.isOpaque()) {
            throw new IllegalArgumentException("The scheme specific part (token) must not start with a slash ('/')!");
        }
        this.uri = uri;
        this.parameters = parameters != null ? Collections.unmodifiableList(parameters) : Collections.unmodifiableList(new ArrayList(0));
    }

    public URI getURI() {
        return this.uri;
    }

    public List<ConfigDescriptionParameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "ConfigDescription [uri=" + this.uri + ", parameters=" + this.parameters + "]";
    }
}

