/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.ConfigDescriptionsChangeListener;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDescriptionRegistry {
    private Logger logger = LoggerFactory.getLogger((String)ConfigDescriptionRegistry.class.getName());
    private final Map<ConfigDescriptionProvider, Collection<ConfigDescription>> configDescriptionMap = new ConcurrentHashMap<ConfigDescriptionProvider, Collection<ConfigDescription>>();
    private final ConfigDescriptionsChangeListener configDescriptionsChangeListener = new ConfigDescriptionsChangeListener(){

        @Override
        public void configDescriptionAdded(ConfigDescriptionProvider configDescriptionProvider, ConfigDescription configDescription) {
            Collection descriptions = (Collection)ConfigDescriptionRegistry.this.configDescriptionMap.get(configDescriptionProvider);
            if (descriptions != null) {
                descriptions.add(configDescription);
            }
        }

        @Override
        public void configDescriptionRemoved(ConfigDescriptionProvider configDescriptionProvider, ConfigDescription configDescription) {
            Collection descriptions = (Collection)ConfigDescriptionRegistry.this.configDescriptionMap.get(configDescriptionProvider);
            if (descriptions != null) {
                descriptions.remove(configDescription);
            }
        }
    };

    protected void addConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        if (!this.configDescriptionMap.containsKey(configDescriptionProvider)) {
            CopyOnWriteArrayList<ConfigDescription> descriptions = new CopyOnWriteArrayList<ConfigDescription>(configDescriptionProvider.getConfigDescriptions());
            configDescriptionProvider.addConfigDescriptionsChangeListener(this.configDescriptionsChangeListener);
            this.configDescriptionMap.put(configDescriptionProvider, descriptions);
            this.logger.debug("Config description provider '{}' has been added.", (Object)configDescriptionProvider.getClass().getName());
        }
    }

    protected void removeConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        if (this.configDescriptionMap.remove(configDescriptionProvider) != null) {
            configDescriptionProvider.removeConfigDescriptionsChangeListener(this.configDescriptionsChangeListener);
            this.logger.debug("Config description provider '{}' has been removed.", (Object)configDescriptionProvider.getClass().getName());
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        for (ConfigDescriptionProvider configDescriptionProvider : this.configDescriptionMap.keySet()) {
            configDescriptionProvider.removeConfigDescriptionsChangeListener(this.configDescriptionsChangeListener);
        }
        this.configDescriptionMap.clear();
    }

    public Collection<ConfigDescription> getConfigDescriptions() {
        ArrayList<ConfigDescription> result = new ArrayList<ConfigDescription>();
        for (Collection<ConfigDescription> descriptions : this.configDescriptionMap.values()) {
            result.addAll(descriptions);
        }
        return result;
    }

    public ConfigDescription getConfigDescription(URI uri) {
        for (Collection<ConfigDescription> descriptions : this.configDescriptionMap.values()) {
            for (ConfigDescription description : descriptions) {
                if (!description.getURI().equals(uri)) continue;
                return description;
            }
        }
        return null;
    }
}

