/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform.internal.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.config.core.ConfigDispatcher;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptTransformationService
implements TransformationService {
    static final Logger logger = LoggerFactory.getLogger(JavaScriptTransformationService.class);

    @Override
    public String transform(String filename, String source) throws TransformationException {
        InputStreamReader reader;
        if (filename == null || source == null) {
            throw new TransformationException("the given parameters 'filename' and 'source' must not be null");
        }
        logger.debug("about to transform '{}' by the Java Script '{}'", (Object)source, (Object)filename);
        try {
            String path = String.valueOf(ConfigDispatcher.getConfigFolder()) + File.separator + "transform" + File.separator + filename;
            reader = new InputStreamReader(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            throw new TransformationException("An error occured while loading script.", e);
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("javascript");
        engine.put("input", source);
        Object result = null;
        long startTime = System.currentTimeMillis();
        try {
            try {
                result = engine.eval(reader);
            }
            catch (ScriptException e) {
                throw new TransformationException("An error occured while executing script.", e);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        logger.trace("JavaScript execution elapsed {} ms", (Object)(System.currentTimeMillis() - startTime));
        return String.valueOf(result);
    }
}

