/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ManagedItemChannelLinkProvider;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;

public class LinkConsoleCommandExtension
implements ConsoleCommandExtension {
    private static final String COMMAND_LINKS = "links";
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ManagedItemChannelLinkProvider managedItemChannelLinkProvider;

    public boolean canHandle(String[] args) {
        String firstArgument = args[0];
        return COMMAND_LINKS.equals(firstArgument);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void execute(String[] args, Console console) {
        String command;
        switch (command = args[0]) {
            case "links": {
                String subCommand;
                if (args.length <= 1) {
                    this.list(console, this.itemChannelLinkRegistry.getAll());
                    return;
                }
                switch (subCommand = args[1]) {
                    case "list": {
                        this.list(console, this.itemChannelLinkRegistry.getAll());
                        return;
                    }
                    case "add": {
                        if (args.length > 3) {
                            String itemName = args[2];
                            ChannelUID channelUID = new ChannelUID(args[3]);
                            this.link(console, itemName, channelUID);
                            return;
                        }
                        console.println("Specify item name and channel UID to link: link <itemName> <channelUID>");
                        return;
                    }
                    case "remove": {
                        if (args.length > 3) {
                            String itemName = args[2];
                            ChannelUID channelUID = new ChannelUID(args[3]);
                            this.remove(console, itemName, channelUID);
                            return;
                        }
                        console.println("Specify item name and channel UID to unlink: link <itemName> <channelUID>");
                        return;
                    }
                    case "clear": {
                        this.clear(console);
                        return;
                    }
                }
                return;
            }
        }
    }

    public List<String> getUsages() {
        return Arrays.asList("links list - lists all links", "links add <itemName> <channelUID> - links an item with a channel", "links remove <itemName> <channelUID> - unlinks an item with a channel", "links clear - removes all managed links");
    }

    private void clear(Console console) {
        Collection itemChannelLinks = this.managedItemChannelLinkProvider.getAll();
        int numberOfLinks = itemChannelLinks.size();
        for (ItemChannelLink itemChannelLink : itemChannelLinks) {
            this.managedItemChannelLinkProvider.remove(itemChannelLink.getID());
        }
        console.println(String.valueOf(numberOfLinks) + " links successfully removed.");
    }

    private void link(Console console, String itemName, ChannelUID channelUID) {
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUID);
        this.managedItemChannelLinkProvider.add(itemChannelLink);
        console.println("Link " + itemChannelLink.toString() + " successfully added.");
    }

    private void list(Console console, Collection<ItemChannelLink> itemChannelLinks) {
        for (ItemChannelLink itemChannelLink : itemChannelLinks) {
            console.println(itemChannelLink.toString());
        }
    }

    private void remove(Console console, String itemName, ChannelUID channelUID) {
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUID);
        ItemChannelLink removedItemChannelLink = (ItemChannelLink)this.managedItemChannelLinkProvider.remove(itemChannelLink.getID());
        if (removedItemChannelLink != null) {
            console.println("Link " + itemChannelLink.toString() + "successfully removed.");
        } else {
            console.println("Could not remove link " + itemChannelLink.toString() + ".");
        }
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void setManagedItemChannelLinkProvider(ManagedItemChannelLinkProvider managedItemChannelLinkProvider) {
        this.managedItemChannelLinkProvider = managedItemChannelLinkProvider;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    protected void unsetManagedItemChannelLinkProvider(ManagedItemChannelLinkProvider managedItemChannelLinkProvider) {
        this.managedItemChannelLinkProvider = null;
    }
}

