/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scriptengine;

public final class ScriptError {
    private final int column;
    private final int length;
    private final int line;
    private final String message;

    public ScriptError(String message, int line, int column, int length) {
        this.message = message;
        this.line = line;
        this.column = column;
        this.length = length;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder(this.message);
        if (this.line != -1) {
            sb.append("; line ");
            sb.append(this.line);
        }
        if (this.column != -1) {
            sb.append(", column ");
            sb.append(this.column);
        }
        if (this.length != -1) {
            sb.append(", length ");
            sb.append(this.length);
        }
        return sb.toString();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }
}

