/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common.registry;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagedProvider<E, K, PE>
extends AbstractProvider<E>
implements ManagedProvider<E, K> {
    private Storage<PE> storage;
    protected static final Logger logger = LoggerFactory.getLogger(AbstractManagedProvider.class);

    @Override
    public void add(E element) {
        if (element == null) {
            throw new IllegalArgumentException("Cannot add null element");
        }
        String keyAsString = this.getKeyAsString(element);
        if (this.storage.get(keyAsString) != null) {
            throw new IllegalArgumentException("Cannot add element, because an element with same UID (" + keyAsString + ") already exists.");
        }
        this.storage.put(keyAsString, this.toPersistableElement(element));
        this.notifyListenersAboutAddedElement(element);
        logger.debug("Added new element to {}.", (Object)this.getClass().getSimpleName());
    }

    @Override
    public Collection<E> getAll() {
        Function toElementList = new Function<String, E>(){

            public E apply(String elementKey) {
                Object persistableElement = AbstractManagedProvider.this.storage.get(elementKey);
                if (persistableElement != null) {
                    return AbstractManagedProvider.this.toElement(elementKey, persistableElement);
                }
                return null;
            }
        };
        Collection<String> keys = this.storage.getKeys();
        Collection elements = Collections2.filter((Collection)Collections2.transform(keys, (Function)toElementList), (Predicate)Predicates.notNull());
        return ImmutableList.copyOf((Collection)elements);
    }

    @Override
    public E remove(K key) {
        E element;
        if (key == null) {
            throw new IllegalArgumentException("Cannot remove null element");
        }
        String keyAsString = this.keyToString(key);
        PE persistableElement = this.storage.remove(keyAsString);
        if (persistableElement != null && (element = this.toElement(keyAsString, persistableElement)) != null) {
            this.notifyListenersAboutRemovedElement(element);
            logger.debug("Removed element from {}.", (Object)this.getClass().getSimpleName());
            return element;
        }
        return null;
    }

    @Override
    public E update(E element) {
        if (element == null) {
            throw new IllegalArgumentException("Cannot update null element");
        }
        String key = this.getKeyAsString(element);
        if (this.storage.get(key) != null) {
            PE persistableElement = this.storage.put(key, this.toPersistableElement(element));
            E oldElement = this.toElement(key, persistableElement);
            this.notifyListenersAboutUpdatedElement(oldElement, element);
            logger.debug("Updated element in {}.", (Object)this.getClass().getSimpleName());
            return oldElement;
        }
        logger.warn("Could not update element with key {} in {}, because it does not exists.", (Object)key, (Object)this.getClass().getSimpleName());
        return null;
    }

    private String getKeyAsString(E element) {
        return this.keyToString(this.getKey(element));
    }

    protected abstract K getKey(E var1);

    protected abstract String getStorageName();

    protected abstract String keyToString(K var1);

    protected void setStorageService(StorageService storageService) {
        this.storage = storageService.getStorage(this.getStorageName(), this.getClass().getClassLoader());
    }

    protected abstract E toElement(String var1, PE var2);

    protected abstract PE toPersistableElement(E var1);

    protected void unsetStorageService(StorageService storageService) {
        this.storage = null;
    }
}

