/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.EventType;
import org.eclipse.smarthome.core.types.State;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventSubscriber
implements EventSubscriber,
EventHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> sourceFilterList = new CopyOnWriteArrayList<String>();

    protected List<String> getSourceFilterList() {
        return this.sourceFilterList;
    }

    public AbstractEventSubscriber() {
        this.sourceFilterList.add("org.eclipse.smarthome.core.autoupdate");
    }

    public void handleEvent(Event event) {
        Object commandObj;
        Object itemNameObj = event.getProperty("item");
        if (!(itemNameObj instanceof String)) {
            return;
        }
        String itemName = (String)itemNameObj;
        if (itemName.isEmpty()) {
            return;
        }
        String source = null;
        Object sourceObj = event.getProperty("source");
        if (sourceObj instanceof String && this.sourceFilterList.contains(source = (String)sourceObj)) {
            return;
        }
        String topic = event.getTopic();
        String[] topicParts = topic.split("/");
        if (topicParts.length <= 2 || !"smarthome".equals(topicParts[0])) {
            return;
        }
        String operation = topicParts[1];
        if (EventType.UPDATE.toString().equals(operation)) {
            Object newStateObj = event.getProperty("state");
            if (newStateObj instanceof State) {
                State newState = (State)newStateObj;
                try {
                    this.receiveUpdate(itemName, newState, source);
                }
                catch (Exception ex) {
                    this.logger.error("An error occured within the 'receiveUpdate' method of the event subscriber!", (Throwable)ex);
                }
            }
        } else if (EventType.COMMAND.toString().equals(operation) && (commandObj = event.getProperty("command")) instanceof Command) {
            Command command = (Command)commandObj;
            try {
                this.receiveCommand(itemName, command, source);
            }
            catch (Exception ex) {
                this.logger.error("An error occured within the 'receiveCommand' method of the event subscriber!", (Throwable)ex);
            }
        }
    }

    protected void receiveCommand(String itemName, Command command, String source) {
        this.receiveCommand(itemName, command);
    }

    @Override
    public void receiveCommand(String itemName, Command command) {
    }

    protected void receiveUpdate(String itemName, State newState, String source) {
        this.receiveUpdate(itemName, newState);
    }

    @Override
    public void receiveUpdate(String itemName, State newState) {
    }
}

