/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.eclipse.smarthome.core.items.ItemsChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRegistryImpl
extends AbstractRegistry<Item>
implements ItemRegistry,
ItemsChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ItemRegistryImpl.class);
    protected EventPublisher eventPublisher;

    @Override
    public void allItemsChanged(ItemProvider provider, Collection<String> oldItemNames) {
        if (oldItemNames == null || oldItemNames.isEmpty()) {
            oldItemNames = new HashSet<String>();
            Collection oldItems = (Collection)this.elementMap.get(provider);
            if (oldItems != null && oldItems.size() > 0) {
                for (Item oldItem : oldItems) {
                    oldItemNames.add(oldItem.getName());
                }
            }
        }
        CopyOnWriteArrayList<Item> items = new CopyOnWriteArrayList<Item>();
        this.elementMap.put(provider, items);
        for (Item item : provider.getAll()) {
            try {
                this.onAddElement(item);
                items.add(item);
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Could not add item: " + ex.getMessage(), (Throwable)ex);
            }
        }
        for (RegistryChangeListener listener : this.listeners) {
            if (!(listener instanceof ItemRegistryChangeListener)) continue;
            ((ItemRegistryChangeListener)listener).allItemsChanged(oldItemNames);
        }
    }

    @Override
    public Item getItem(String name) throws ItemNotFoundException {
        for (Item item : this.getItems()) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        throw new ItemNotFoundException(name);
    }

    @Override
    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        Collection<Item> items = this.getItems(name);
        if (items.isEmpty()) {
            throw new ItemNotFoundException(name);
        }
        if (items.size() > 1) {
            throw new ItemNotUniqueException(name, items);
        }
        return items.iterator().next();
    }

    @Override
    public Collection<Item> getItems() {
        return this.getAll();
    }

    @Override
    public Collection<Item> getItems(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        ArrayList<Item> matchedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!item.getName().matches(regex)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    @Override
    public boolean isValidItemName(String name) {
        return name.matches("[a-zA-Z0-9_]*");
    }

    private void addToGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            try {
                Item groupItem = this.getItem(groupName);
                if (!(groupItem instanceof GroupItem)) continue;
                ((GroupItem)groupItem).addMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
    }

    private void initializeItem(Item item) throws IllegalArgumentException {
        if (this.isValidItemName(item.getName())) {
            if (item instanceof GenericItem) {
                GenericItem genericItem = (GenericItem)item;
                genericItem.setEventPublisher(this.eventPublisher);
                genericItem.initialize();
            }
            if (item instanceof GroupItem) {
                for (Item i : this.getItems()) {
                    if (!i.getGroupNames().contains(item.getName())) continue;
                    ((GroupItem)item).addMember(i);
                }
            }
        } else {
            throw new IllegalArgumentException("Ignoring item '" + item.getName() + "' as it does not comply with" + " the naming convention.");
        }
        this.addToGroupItems(item, item.getGroupNames());
    }

    private void removeFromGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            try {
                Item groupItem = this.getItem(groupName);
                if (!(groupItem instanceof GroupItem)) continue;
                ((GroupItem)groupItem).removeMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
    }

    @Override
    protected void onAddElement(Item element) throws IllegalArgumentException {
        this.initializeItem(element);
    }

    @Override
    protected void onRemoveElement(Item element) {
        this.removeFromGroupItems(element, element.getGroupNames());
    }

    @Override
    protected void onUpdateElement(Item oldItem, Item item) {
        this.removeFromGroupItems(oldItem, oldItem.getGroupNames());
        this.addToGroupItems(item, item.getGroupNames());
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(eventPublisher);
        }
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(null);
        }
    }
}

