/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.List;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public interface GroupFunction {
    public State calculate(List<Item> var1);

    public State getStateAs(List<Item> var1, Class<? extends State> var2);

    public static class Equality
    implements GroupFunction {
        @Override
        public State calculate(List<Item> items) {
            if (items.size() > 0) {
                State state = items.get(0).getState();
                int i = 1;
                while (i < items.size()) {
                    if (!state.equals(items.get(i).getState())) {
                        return UnDefType.UNDEF;
                    }
                    ++i;
                }
                return state;
            }
            return UnDefType.UNDEF;
        }

        @Override
        public State getStateAs(List<Item> items, Class<? extends State> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return state;
            }
            return null;
        }
    }
}

