/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupItem
extends GenericItem
implements StateChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(GroupItem.class);
    protected final GenericItem baseItem;
    protected final List<Item> members = new CopyOnWriteArrayList<Item>();
    protected GroupFunction function;

    public GroupItem(String name) {
        this(name, (GenericItem)null);
    }

    public GroupItem(String name, GenericItem baseItem) {
        this(name, baseItem, new GroupFunction.Equality());
    }

    public GroupItem(String name, GenericItem baseItem, GroupFunction function) {
        super("Group", name);
        this.function = function;
        this.baseItem = baseItem;
    }

    public GenericItem getBaseItem() {
        return this.baseItem;
    }

    public List<Item> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public List<Item> getAllMembers() {
        HashSet<Item> allMembers = new HashSet<Item>();
        this.collectMembers(allMembers, this.members);
        return ImmutableList.copyOf(allMembers);
    }

    private void collectMembers(Set<Item> allMembers, List<Item> members) {
        for (Item member : members) {
            if (member instanceof GroupItem) {
                this.collectMembers(allMembers, ((GroupItem)member).members);
                continue;
            }
            allMembers.add(member);
        }
    }

    public void addMember(Item item) {
        this.members.add(item);
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.addStateChangeListener(this);
        }
    }

    public void removeMember(Item item) {
        this.members.remove(item);
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.removeStateChangeListener(this);
        }
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        if (this.baseItem != null) {
            return this.baseItem.getAcceptedDataTypes();
        }
        List<Class<? extends State>> acceptedDataTypes = null;
        for (Item item : this.members) {
            if (acceptedDataTypes == null) {
                acceptedDataTypes = item.getAcceptedDataTypes();
                continue;
            }
            acceptedDataTypes.retainAll(item.getAcceptedDataTypes());
        }
        return acceptedDataTypes == null ? Collections.EMPTY_LIST : acceptedDataTypes;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        if (this.baseItem != null) {
            return this.baseItem.getAcceptedCommandTypes();
        }
        List<Class<? extends Command>> acceptedCommandTypes = null;
        for (Item item : this.members) {
            if (acceptedCommandTypes == null) {
                acceptedCommandTypes = item.getAcceptedCommandTypes();
                continue;
            }
            acceptedCommandTypes.retainAll(item.getAcceptedCommandTypes());
        }
        return acceptedCommandTypes == null ? Collections.EMPTY_LIST : acceptedCommandTypes;
    }

    public void send(Command command) {
        if (this.getAcceptedCommandTypes().contains(command.getClass())) {
            this.internalSend(command);
        } else {
            logger.warn("Command '{}' has been ignored for group '{}' as it is not accepted.", (Object)command.toString(), (Object)this.getName());
        }
    }

    @Override
    protected void internalSend(Command command) {
        if (this.eventPublisher != null) {
            for (Item member : this.members) {
                this.eventPublisher.sendCommand(member.getName(), command);
            }
        }
    }

    @Override
    public State getStateAs(Class<? extends State> typeClass) {
        State newState = this.function.getStateAs(this.getAllMembers(), typeClass);
        if (newState == null && this.baseItem != null) {
            this.baseItem.setState(this.state);
            newState = this.baseItem.getStateAs(typeClass);
        }
        if (newState == null) {
            newState = super.getStateAs(typeClass);
        }
        return newState;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " (" + "Type=" + this.getClass().getSimpleName() + ", " + (this.baseItem != null ? "BaseType=" + this.baseItem.getClass().getSimpleName() + ", " : "") + "Members=" + this.members.size() + ", " + "State=" + this.getState() + ")";
    }

    @Override
    public void stateChanged(Item item, State oldState, State newState) {
        this.setState(this.function.calculate(this.members));
    }

    @Override
    public void stateUpdated(Item item, State state) {
        this.setState(this.function.calculate(this.members));
    }
}

