/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypesSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawSuperTypes {
    public Set<JvmType> collect(JvmType type) {
        Set<JvmType> result = new Implementation().collect(type);
        result.remove(type);
        return result;
    }

    public Set<String> collectNames(JvmType type) {
        Set<JvmType> superTypes = this.collect(type);
        HashSet superTypeNames = Sets.newHashSet();
        for (JvmType collectedSuperType : superTypes) {
            superTypeNames.add(collectedSuperType.getIdentifier());
        }
        return superTypeNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Implementation
    extends TypesSwitch<Boolean> {
        private Set<JvmType> collectedSuperTypes = Sets.newLinkedHashSet();

        protected Implementation() {
        }

        public Boolean doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return Boolean.FALSE;
            }
            return (Boolean)super.doSwitch(theEObject);
        }

        @Override
        public Boolean caseJvmTypeReference(JvmTypeReference object) {
            return this.doSwitch(object.getType());
        }

        @Override
        public Boolean caseJvmType(JvmType object) {
            return this.collectedSuperTypes.add(object);
        }

        @Override
        public Boolean caseJvmArrayType(JvmArrayType object) {
            return this.collectedSuperTypes.add(object);
        }

        @Override
        public Boolean caseJvmDeclaredType(JvmDeclaredType object) {
            if (this.collectedSuperTypes.add(object)) {
                for (JvmTypeReference superType : object.getSuperTypes()) {
                    this.doSwitch(superType);
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Set<JvmType> collect(JvmType sub) {
            this.doSwitch(sub);
            return this.collectedSuperTypes;
        }
    }
}

