/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.model.rule.rules.ChangedEventTrigger;
import org.eclipse.smarthome.model.rule.rules.CommandEventTrigger;
import org.eclipse.smarthome.model.rule.rules.EventTrigger;
import org.eclipse.smarthome.model.rule.rules.Rule;
import org.eclipse.smarthome.model.rule.rules.RuleModel;
import org.eclipse.smarthome.model.rule.rules.VariableDeclaration;
import org.eclipse.smarthome.model.script.engine.IItemRegistryProvider;
import org.eclipse.smarthome.model.script.jvmmodel.ScriptJvmModelInferrer;
import org.eclipse.smarthome.model.script.scoping.StateAndCommandProvider;
import org.eclipse.smarthome.model.script.script.Script;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesJvmModelInferrer
extends ScriptJvmModelInferrer {
    private static final Logger logger = LoggerFactory.getLogger(RulesJvmModelInferrer.class);
    public static final String VAR_PREVIOUS_STATE = "previousState";
    public static final String VAR_RECEIVED_COMMAND = "receivedCommand";
    @Inject
    @Extension
    private JvmTypesBuilder _jvmTypesBuilder;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private IItemRegistryProvider itemRegistryProvider;
    @Inject
    private StateAndCommandProvider stateAndCommandProvider;

    protected void _infer(final RuleModel ruleModel, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        Resource _eResource = ruleModel.eResource();
        URI _uRI = _eResource.getURI();
        String _lastSegment = _uRI.lastSegment();
        String[] _split = _lastSegment.split("\\.");
        String _head = (String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
        String _firstUpper = StringExtensions.toFirstUpper((String)_head);
        String className = String.valueOf(_firstUpper) + "Rules";
        JvmGenericType _class = this._jvmTypesBuilder.toClass((EObject)ruleModel, className);
        IJvmDeclaredTypeAcceptor.IPostIndexingInitializing _accept = acceptor.accept((JvmDeclaredType)_class);
        Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(final JvmGenericType it) {
                EList _members = it.getMembers();
                EList<VariableDeclaration> _variables = ruleModel.getVariables();
                Functions.Function1<VariableDeclaration, JvmField> _function = new Functions.Function1<VariableDeclaration, JvmField>(){

                    public JvmField apply(final VariableDeclaration it) {
                        String _name = it.getName();
                        JvmTypeReference _type = it.getType();
                        JvmTypeReference _cloneWithProxies = null;
                        if (_type != null) {
                            _cloneWithProxies = RulesJvmModelInferrer.this._jvmTypesBuilder.cloneWithProxies(_type);
                        }
                        JvmField _field = RulesJvmModelInferrer.this._jvmTypesBuilder.toField((EObject)it, _name, _cloneWithProxies);
                        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

                            public void apply(JvmField field) {
                                field.setStatic(true);
                                boolean _isWriteable = it.isWriteable();
                                boolean _not = !_isWriteable;
                                field.setFinal(_not);
                                XExpression _right = it.getRight();
                                RulesJvmModelInferrer.this._jvmTypesBuilder.setInitializer(field, _right);
                            }
                        };
                        return (JvmField)ObjectExtensions.operator_doubleArrow((Object)_field, (Procedures.Procedure1)_function);
                    }
                };
                List _map = ListExtensions.map(_variables, (Functions.Function1)_function);
                RulesJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Iterable)_map);
                final HashSet fieldNames = CollectionLiterals.newHashSet((Object[])new String[0]);
                Iterable types = RulesJvmModelInferrer.this.stateAndCommandProvider.getAllTypes();
                Procedures.Procedure1<Type> _function_1 = new Procedures.Procedure1<Type>(){

                    public void apply(Type type) {
                        String name = type.toString();
                        boolean _add = fieldNames.add(name);
                        if (_add) {
                            EList _members = it.getMembers();
                            Class<?> _class = type.getClass();
                            JvmTypeReference _newTypeRef = RulesJvmModelInferrer.this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, _class, new JvmTypeReference[0]);
                            Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

                                public void apply(JvmField it) {
                                    it.setStatic(true);
                                }
                            };
                            JvmField _field = RulesJvmModelInferrer.this._jvmTypesBuilder.toField((EObject)ruleModel, name, _newTypeRef, (Procedures.Procedure1)_function);
                            RulesJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_field);
                        } else {
                            Class<?> _class_1 = type.getClass();
                            String _name = _class_1.getName();
                            logger.warn("Duplicate field: '{}'. Ignoring '{}'.", (Object)name, (Object)_name);
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)types, (Procedures.Procedure1)_function_1);
                ItemRegistry itemRegistry = (ItemRegistry)RulesJvmModelInferrer.this.itemRegistryProvider.get();
                Collection _items = null;
                if (itemRegistry != null) {
                    _items = itemRegistry.getItems();
                }
                if (_items != null) {
                    Procedures.Procedure1<Item> _function_2 = new Procedures.Procedure1<Item>(){

                        public void apply(Item item) {
                            String name = item.getName();
                            boolean _add = fieldNames.add(name);
                            if (_add) {
                                EList _members = it.getMembers();
                                String _name = item.getName();
                                Class<?> _class = item.getClass();
                                JvmTypeReference _newTypeRef = RulesJvmModelInferrer.this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, _class, new JvmTypeReference[0]);
                                Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

                                    public void apply(JvmField it) {
                                        it.setStatic(true);
                                    }
                                };
                                JvmField _field = RulesJvmModelInferrer.this._jvmTypesBuilder.toField((EObject)ruleModel, _name, _newTypeRef, (Procedures.Procedure1)_function);
                                RulesJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_field);
                            } else {
                                String _name_1 = item.getName();
                                Class<?> _class_1 = item.getClass();
                                String _name_2 = _class_1.getName();
                                logger.warn("Duplicate field: '{}'. Ignoring '{}'.", (Object)_name_1, (Object)_name_2);
                            }
                        }
                    };
                    IterableExtensions.forEach((Iterable)_items, (Procedures.Procedure1)_function_2);
                }
                EList _members_1 = it.getMembers();
                EList<Rule> _rules = ruleModel.getRules();
                Functions.Function1<Rule, JvmOperation> _function_3 = new Functions.Function1<Rule, JvmOperation>(){

                    public JvmOperation apply(final Rule rule) {
                        String _name = rule.getName();
                        String _plus = "_" + _name;
                        JvmTypeReference _newTypeRef = RulesJvmModelInferrer.this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, Void.TYPE, new JvmTypeReference[0]);
                        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

                            public void apply(JvmOperation it) {
                                boolean _containsStateChangeTrigger;
                                it.setStatic(true);
                                boolean _containsCommandTrigger = RulesJvmModelInferrer.this.containsCommandTrigger(rule);
                                if (_containsCommandTrigger) {
                                    JvmTypeReference commandTypeRef = RulesJvmModelInferrer.this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, Command.class, new JvmTypeReference[0]);
                                    EList _parameters = it.getParameters();
                                    JvmFormalParameter _parameter = RulesJvmModelInferrer.this._jvmTypesBuilder.toParameter((EObject)rule, RulesJvmModelInferrer.VAR_RECEIVED_COMMAND, commandTypeRef);
                                    RulesJvmModelInferrer.this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                                }
                                if (_containsStateChangeTrigger = RulesJvmModelInferrer.this.containsStateChangeTrigger(rule)) {
                                    JvmTypeReference stateTypeRef = RulesJvmModelInferrer.this._jvmTypesBuilder.newTypeRef((EObject)ruleModel, State.class, new JvmTypeReference[0]);
                                    EList _parameters_1 = it.getParameters();
                                    JvmFormalParameter _parameter_1 = RulesJvmModelInferrer.this._jvmTypesBuilder.toParameter((EObject)rule, RulesJvmModelInferrer.VAR_PREVIOUS_STATE, stateTypeRef);
                                    RulesJvmModelInferrer.this._jvmTypesBuilder.operator_add(_parameters_1, (Object)_parameter_1);
                                }
                                XBlockExpression _script = rule.getScript();
                                RulesJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, (XExpression)_script);
                            }
                        };
                        return RulesJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)rule, _plus, _newTypeRef, (Procedures.Procedure1)_function);
                    }
                };
                List _map_1 = ListExtensions.map(_rules, (Functions.Function1)_function_3);
                RulesJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Iterable)_map_1);
            }
        };
        _accept.initializeLater((Procedures.Procedure1)_function);
    }

    private boolean containsCommandTrigger(Rule rule) {
        EList<EventTrigger> _eventtrigger = rule.getEventtrigger();
        for (EventTrigger trigger : _eventtrigger) {
            if (!(trigger instanceof CommandEventTrigger)) continue;
            return true;
        }
        return false;
    }

    private boolean containsStateChangeTrigger(Rule rule) {
        EList<EventTrigger> _eventtrigger = rule.getEventtrigger();
        for (EventTrigger trigger : _eventtrigger) {
            if (!(trigger instanceof ChangedEventTrigger)) continue;
            return true;
        }
        return false;
    }

    public void infer(EObject ruleModel, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (ruleModel instanceof Script) {
            this._infer((Script)ruleModel, acceptor, isPreIndexingPhase);
            return;
        }
        if (ruleModel instanceof RuleModel) {
            this._infer((RuleModel)ruleModel, acceptor, isPreIndexingPhase);
            return;
        }
        if (ruleModel != null) {
            this._infer(ruleModel, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ruleModel, acceptor, isPreIndexingPhase).toString());
    }
}

