/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ExternalToolsBuilderTab
extends AbstractLaunchConfigurationTab {
    protected Button afterClean;
    protected Button fDuringClean;
    protected Button autoBuildButton;
    protected Button manualBuild;
    protected Button workingSetButton;
    protected Button specifyResources;
    protected Button fLaunchInBackgroundButton;
    protected IWorkingSet workingSet;
    protected ILaunchConfiguration fConfiguration;
    private boolean fCreateBuildScheduleComponent = true;
    private Button fConsoleOutput;
    private Button fFileOutput;
    private Button fFileBrowse;
    private Text fFileText;
    private Button fVariables;
    private Button fAppend;
    private Button fWorkspaceBrowse;
    protected SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enabled = !ExternalToolsBuilderTab.this.fCreateBuildScheduleComponent || ExternalToolsBuilderTab.this.autoBuildButton.getSelection() || ExternalToolsBuilderTab.this.manualBuild.getSelection();
            ExternalToolsBuilderTab.this.workingSetButton.setEnabled(enabled);
            ExternalToolsBuilderTab.this.specifyResources.setEnabled(enabled && ExternalToolsBuilderTab.this.workingSetButton.getSelection());
            ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
        }
    };

    public ExternalToolsBuilderTab() {
        this.setHelpContextId("org.eclipse.ui.externaltools.builders_tab_context");
    }

    public ExternalToolsBuilderTab(boolean createBuildScheduleComponent) {
        this.fCreateBuildScheduleComponent = createBuildScheduleComponent;
        this.setHelpContextId("org.eclipse.ui.externaltools.builders_tab_context");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createOutputCaptureComponent(mainComposite);
        this.createLaunchInBackgroundComposite(mainComposite);
        this.createBuildScheduleComponent(mainComposite);
    }

    protected void createLaunchInBackgroundComposite(Composite parent) {
        this.fLaunchInBackgroundButton = this.createCheckButton(parent, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_14);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fLaunchInBackgroundButton.setLayoutData((Object)data);
        this.fLaunchInBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createBuildScheduleComponent(Composite parent) {
        if (this.fCreateBuildScheduleComponent) {
            Label label = new Label(parent, 0);
            label.setText(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Run_this_builder_for__1);
            label.setFont(parent.getFont());
            this.afterClean = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab__Full_builds_2, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Full, 2);
            this.manualBuild = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab__Incremental_builds_4, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Inc, 2);
            this.autoBuildButton = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab__Auto_builds__Not_recommended__6, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Auto, 2);
            this.fDuringClean = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_0, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_1, 2);
            this.createVerticalSpacer(parent, 2);
        }
        this.workingSetButton = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_workingSet_label, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_workingSet_tooltip, 1);
        this.specifyResources = this.createPushButton(parent, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_13, null);
        GridData gd = new GridData(128);
        this.specifyResources.setLayoutData((Object)gd);
        this.specifyResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuilderTab.this.selectResources();
            }
        });
        Label label = new Label(parent, 0);
        label.setText(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_2);
        label.setFont(parent.getFont());
    }

    private void createOutputCaptureComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_17);
        GridData gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(5, false);
        group.setLayout((Layout)layout);
        group.setFont(parent.getFont());
        this.fConsoleOutput = this.createCheckButton((Composite)group, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_18);
        gd = new GridData(1, 0, true, false);
        gd.horizontalSpan = 5;
        this.fConsoleOutput.setLayoutData((Object)gd);
        this.fConsoleOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fFileOutput = this.createCheckButton((Composite)group, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_19);
        this.fFileOutput.setLayoutData((Object)new GridData(1, 0, false, false));
        this.fFileText = new Text((Composite)group, 2052);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 4;
        this.fFileText.setLayoutData((Object)gd);
        this.fFileText.setFont(parent.getFont());
        Label spacer = new Label((Composite)group, 0);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
        this.fWorkspaceBrowse = this.createPushButton((Composite)group, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_20, null);
        this.fFileBrowse = this.createPushButton((Composite)group, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_21, null);
        this.fVariables = this.createPushButton((Composite)group, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_22, null);
        spacer = new Label((Composite)group, 0);
        spacer.setLayoutData((Object)new GridData(4, 0, false, false));
        this.fAppend = this.createCheckButton((Composite)group, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_23);
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 4;
        this.fAppend.setLayoutData((Object)gd);
        this.fFileOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ExternalToolsBuilderTab.this.fFileOutput.getSelection();
                ExternalToolsBuilderTab.this.fFileText.setEnabled(enabled);
                ExternalToolsBuilderTab.this.fFileBrowse.setEnabled(enabled);
                ExternalToolsBuilderTab.this.fWorkspaceBrowse.setEnabled(enabled);
                ExternalToolsBuilderTab.this.fVariables.setEnabled(enabled);
                ExternalToolsBuilderTab.this.fAppend.setEnabled(enabled);
                ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAppend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(ExternalToolsBuilderTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_24);
                dialog.setMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_25);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                int buttonId = dialog.open();
                if (buttonId == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                    ExternalToolsBuilderTab.this.fFileText.setText(fileLoc);
                }
            }
        });
        this.fFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = ExternalToolsBuilderTab.this.fFileText.getText();
                FileDialog dialog = new FileDialog(ExternalToolsBuilderTab.this.getShell(), 8192);
                filePath = dialog.open();
                if (filePath != null) {
                    ExternalToolsBuilderTab.this.fFileText.setText(filePath);
                }
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fVariables.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ExternalToolsBuilderTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ExternalToolsBuilderTab.this.fFileText.insert(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Button createButton(Composite parent, SelectionListener listener, String text, String tooltipText, int columns) {
        Button button = this.createCheckButton(parent, text);
        button.setToolTipText(tooltipText);
        button.addSelectionListener(listener);
        GridData gd = new GridData(768);
        gd.horizontalSpan = columns;
        button.setLayoutData((Object)gd);
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        StringBuffer buffer = new StringBuffer("full");
        buffer.append(',');
        buffer.append("incremental");
        buffer.append(',');
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
        if (this.fCreateBuildScheduleComponent) {
            this.afterClean.setSelection(false);
            this.manualBuild.setSelection(false);
            this.autoBuildButton.setSelection(false);
            this.fDuringClean.setSelection(false);
        }
        String buildKindString = null;
        String buildScope = null;
        try {
            buildKindString = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", "");
            buildScope = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        }
        catch (CoreException coreException) {}
        this.workingSetButton.setSelection(buildScope != null);
        this.workingSetButton.setEnabled(buildScope != null);
        if (buildScope != null) {
            this.workingSet = RefreshTab.getWorkingSet((String)buildScope);
        }
        if (this.fCreateBuildScheduleComponent) {
            int[] buildTypes = BuilderUtils.buildTypesToArray(buildKindString);
            int i = 0;
            while (i < buildTypes.length) {
                switch (buildTypes[i]) {
                    case 6: {
                        this.afterClean.setSelection(true);
                        break;
                    }
                    case 10: {
                        this.manualBuild.setSelection(true);
                        break;
                    }
                    case 9: {
                        this.autoBuildButton.setSelection(true);
                        break;
                    }
                    case 15: {
                        this.fDuringClean.setSelection(true);
                        break;
                    }
                }
                ++i;
            }
        }
        boolean enabled = true;
        if (this.fCreateBuildScheduleComponent) {
            enabled = this.autoBuildButton.getSelection() || this.manualBuild.getSelection();
        }
        this.workingSetButton.setEnabled(enabled);
        this.specifyResources.setEnabled(enabled && this.workingSetButton.getSelection());
        this.updateRunInBackground(configuration);
        this.updateConsoleOutput(configuration);
    }

    protected void updateRunInBackground(ILaunchConfiguration configuration) {
        this.fLaunchInBackgroundButton.setSelection(ExternalToolsCoreUtil.isAsynchronousBuild((ILaunchConfiguration)configuration));
    }

    private void updateConsoleOutput(ILaunchConfiguration configuration) {
        boolean haveOutputFile;
        boolean outputToConsole = true;
        String outputFile = null;
        boolean append = false;
        try {
            outputToConsole = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
            outputFile = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", null);
            append = configuration.getAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", false);
        }
        catch (CoreException coreException) {}
        this.fConsoleOutput.setSelection(outputToConsole);
        this.fAppend.setSelection(append);
        boolean bl = haveOutputFile = outputFile != null;
        if (haveOutputFile) {
            this.fFileText.setText(outputFile);
        }
        this.fFileOutput.setSelection(haveOutputFile);
        this.fFileText.setEnabled(haveOutputFile);
        this.fFileBrowse.setEnabled(haveOutputFile);
        this.fWorkspaceBrowse.setEnabled(haveOutputFile);
        this.fVariables.setEnabled(haveOutputFile);
        this.fAppend.setEnabled(haveOutputFile);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fCreateBuildScheduleComponent) {
            StringBuffer buffer = new StringBuffer();
            if (this.afterClean.getSelection()) {
                buffer.append("full").append(',');
            }
            if (this.manualBuild.getSelection()) {
                buffer.append("incremental").append(',');
            }
            if (this.autoBuildButton.getSelection()) {
                buffer.append("auto").append(',');
            }
            if (this.fDuringClean.getSelection()) {
                buffer.append("clean");
            }
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
        }
        if (this.workingSetButton.getSelection()) {
            String scope = RefreshTab.getRefreshAttribute((IWorkingSet)this.workingSet);
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", scope);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        }
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", this.fLaunchInBackgroundButton.getSelection());
        boolean captureOutput = false;
        if (this.fConsoleOutput.getSelection()) {
            captureOutput = true;
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", null);
        } else {
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
        }
        if (this.fFileOutput.getSelection()) {
            captureOutput = true;
            String file = this.fFileText.getText();
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", file);
            if (this.fAppend.getSelection()) {
                configuration.setAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", true);
            } else {
                configuration.setAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", null);
            }
        } else {
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", null);
        }
        if (!captureOutput) {
            configuration.setAttribute("org.eclipse.debug.core.capture_output", false);
        } else {
            configuration.setAttribute("org.eclipse.debug.core.capture_output", null);
        }
    }

    public String getName() {
        return ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Build_Options_9;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fCreateBuildScheduleComponent) {
            boolean buildKindSelected;
            boolean bl = buildKindSelected = this.afterClean.getSelection() || this.manualBuild.getSelection() || this.autoBuildButton.getSelection() || this.fDuringClean.getSelection();
            if (!buildKindSelected) {
                this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_buildKindError);
                return false;
            }
        }
        if (this.workingSetButton.getSelection() && (this.workingSet == null || this.workingSet.getElements().length == 0)) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_16);
            return false;
        }
        return this.validateRedirectFile();
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    private void selectResources() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        if (this.workingSet == null) {
            this.workingSet = workingSetManager.createWorkingSet(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_15, new IAdaptable[0]);
        }
        IWorkingSetEditWizard wizard = workingSetManager.createWorkingSetEditWizard(this.workingSet);
        WizardDialog dialog = new WizardDialog(ExternalToolsPlugin.getStandardDisplay().getActiveShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 1) {
            return;
        }
        this.workingSet = wizard.getSelection();
        this.updateLaunchConfigurationDialog();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private boolean validateRedirectFile() {
        int len;
        if (this.fFileOutput.getSelection() && (len = this.fFileText.getText().trim().length()) == 0) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_26);
            return false;
        }
        return true;
    }
}

