/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.text.UnicodeSet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class UBiDiProps {
    private int[] indexes;
    private int[] mirrors;
    private byte[] jgArray;
    private Trie2_16 trie;
    private static final String DATA_NAME = "ubidi";
    private static final String DATA_TYPE = "icu";
    private static final String DATA_FILE_NAME = "ubidi.icu";
    private static final byte[] FMT = new byte[]{66, 105, 68, 105};
    private static final int IX_TRIE_SIZE = 2;
    private static final int IX_MIRROR_LENGTH = 3;
    private static final int IX_JG_START = 4;
    private static final int IX_JG_LIMIT = 5;
    private static final int IX_MAX_VALUES = 15;
    private static final int IX_TOP = 16;
    private static final int JT_SHIFT = 5;
    private static final int BPT_SHIFT = 8;
    private static final int JOIN_CONTROL_SHIFT = 10;
    private static final int BIDI_CONTROL_SHIFT = 11;
    private static final int IS_MIRRORED_SHIFT = 12;
    private static final int MIRROR_DELTA_SHIFT = 13;
    private static final int MAX_JG_SHIFT = 16;
    private static final int CLASS_MASK = 31;
    private static final int JT_MASK = 224;
    private static final int BPT_MASK = 768;
    private static final int MAX_JG_MASK = 0xFF0000;
    private static final int ESC_MIRROR_DELTA = -4;
    private static final int MIRROR_INDEX_SHIFT = 21;
    public static final UBiDiProps INSTANCE;

    static {
        try {
            INSTANCE = new UBiDiProps();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private UBiDiProps() throws IOException {
        InputStream is = ICUData.getStream("data/icudt52b/ubidi.icu");
        BufferedInputStream b = new BufferedInputStream(is, 4096);
        this.readData(b);
        b.close();
        is.close();
    }

    private void readData(InputStream is) throws IOException {
        DataInputStream inputStream = new DataInputStream(is);
        ICUBinary.readHeader(inputStream, FMT, new IsAcceptable());
        int count = inputStream.readInt();
        if (count < 16) {
            throw new IOException("indexes[0] too small in ubidi.icu");
        }
        this.indexes = new int[count];
        this.indexes[0] = count;
        int i = 1;
        while (i < count) {
            this.indexes[i] = inputStream.readInt();
            ++i;
        }
        this.trie = Trie2_16.createFromSerialized(inputStream);
        int expectedTrieLength = this.indexes[2];
        int trieLength = this.trie.getSerializedLength();
        if (trieLength > expectedTrieLength) {
            throw new IOException("ubidi.icu: not enough bytes for the trie");
        }
        inputStream.skipBytes(expectedTrieLength - trieLength);
        count = this.indexes[3];
        if (count > 0) {
            this.mirrors = new int[count];
            i = 0;
            while (i < count) {
                this.mirrors[i] = inputStream.readInt();
                ++i;
            }
        }
        count = this.indexes[5] - this.indexes[4];
        this.jgArray = new byte[count];
        i = 0;
        while (i < count) {
            this.jgArray[i] = inputStream.readByte();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void addPropertyStarts(UnicodeSet set) {
        trieIterator = this.trie.iterator();
        if (true) ** GOTO lbl6
        do {
            set.add(range.startCodePoint);
lbl6:
            // 2 sources

            if (!trieIterator.hasNext()) break;
            range = trieIterator.next();
        } while (!range.leadSurrogate);
        length = this.indexes[3];
        i = 0;
        while (i < length) {
            c = UBiDiProps.getMirrorCodePoint(this.mirrors[i]);
            set.add(c, c + 1);
            ++i;
        }
        start = this.indexes[4];
        limit = this.indexes[5];
        length = limit - start;
        prev = 0;
        i = 0;
        while (i < length) {
            jg = this.jgArray[i];
            if (jg != prev) {
                set.add(start);
                prev = jg;
            }
            ++start;
            ++i;
        }
        if (prev != 0) {
            set.add(limit);
        }
    }

    public final int getMaxValue(int which) {
        int max = this.indexes[15];
        switch (which) {
            case 4096: {
                return max & 0x1F;
            }
            case 4102: {
                return (max & 0xFF0000) >> 16;
            }
            case 4103: {
                return (max & 0xE0) >> 5;
            }
            case 4117: {
                return (max & 0x300) >> 8;
            }
        }
        return -1;
    }

    public final int getClass(int c) {
        return UBiDiProps.getClassFromProps(this.trie.get(c));
    }

    public final boolean isMirrored(int c) {
        return UBiDiProps.getFlagFromProps(this.trie.get(c), 12);
    }

    private final int getMirror(int c, int props) {
        int delta = UBiDiProps.getMirrorDeltaFromProps(props);
        if (delta != -4) {
            return c + delta;
        }
        int length = this.indexes[3];
        int i = 0;
        while (i < length) {
            int m = this.mirrors[i];
            int c2 = UBiDiProps.getMirrorCodePoint(m);
            if (c == c2) {
                return UBiDiProps.getMirrorCodePoint(this.mirrors[UBiDiProps.getMirrorIndex(m)]);
            }
            if (c < c2) break;
            ++i;
        }
        return c;
    }

    public final int getMirror(int c) {
        int props = this.trie.get(c);
        return this.getMirror(c, props);
    }

    public final boolean isBidiControl(int c) {
        return UBiDiProps.getFlagFromProps(this.trie.get(c), 11);
    }

    public final boolean isJoinControl(int c) {
        return UBiDiProps.getFlagFromProps(this.trie.get(c), 10);
    }

    public final int getJoiningType(int c) {
        return (this.trie.get(c) & 0xE0) >> 5;
    }

    public final int getJoiningGroup(int c) {
        int start = this.indexes[4];
        int limit = this.indexes[5];
        if (start <= c && c < limit) {
            return this.jgArray[c - start] & 0xFF;
        }
        return 0;
    }

    public final int getPairedBracketType(int c) {
        return (this.trie.get(c) & 0x300) >> 8;
    }

    public final int getPairedBracket(int c) {
        int props = this.trie.get(c);
        if ((props & 0x300) == 0) {
            return c;
        }
        return this.getMirror(c, props);
    }

    private static final int getClassFromProps(int props) {
        return props & 0x1F;
    }

    private static final boolean getFlagFromProps(int props, int shift) {
        return (props >> shift & 1) != 0;
    }

    private static final int getMirrorDeltaFromProps(int props) {
        return (short)props >> 13;
    }

    private static final int getMirrorCodePoint(int m) {
        return m & 0x1FFFFF;
    }

    private static final int getMirrorIndex(int m) {
        return m >>> 21;
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        public boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 2;
        }
    }
}

