/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.AbstractDescriptionType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.TypeResolver;

public class ThingType
extends AbstractDescriptionType {
    private final List<ChannelGroupDefinition> channelGroupDefinitions;
    private final List<ChannelDefinition> channelDefinitions;
    private final List<String> supportedBridgeTypeUIDs;
    private final Map<String, String> properties;
    private URI configDescriptionURI;
    private boolean listed;

    public ThingType(String bindingId, String thingTypeId, String label) throws IllegalArgumentException {
        this(new ThingTypeUID(bindingId, thingTypeId), null, label, null, true, null, null, null, null);
    }

    public ThingType(ThingTypeUID uid, List<String> supportedBridgeTypeUIDs, String label, String description, List<ChannelDefinition> channelDefinitions, List<ChannelGroupDefinition> channelGroupDefinitions, Map<String, String> properties, URI configDescriptionURI) throws IllegalArgumentException {
        this(uid, supportedBridgeTypeUIDs, label, description, true, channelDefinitions, channelGroupDefinitions, properties, configDescriptionURI);
    }

    public ThingType(ThingTypeUID uid, List<String> supportedBridgeTypeUIDs, String label, String description, boolean listed, List<ChannelDefinition> channelDefinitions, List<ChannelGroupDefinition> channelGroupDefinitions, Map<String, String> properties, URI configDescriptionURI) throws IllegalArgumentException {
        super(uid, label, description);
        this.listed = listed;
        this.supportedBridgeTypeUIDs = supportedBridgeTypeUIDs != null ? Collections.unmodifiableList(supportedBridgeTypeUIDs) : Collections.unmodifiableList(new ArrayList(0));
        this.channelDefinitions = channelDefinitions != null ? Collections.unmodifiableList(channelDefinitions) : Collections.unmodifiableList(new ArrayList(0));
        this.channelGroupDefinitions = channelGroupDefinitions != null ? Collections.unmodifiableList(channelGroupDefinitions) : Collections.unmodifiableList(new ArrayList(0));
        this.properties = properties != null ? Collections.unmodifiableMap(properties) : Collections.unmodifiableMap(new HashMap(0));
        this.configDescriptionURI = configDescriptionURI;
    }

    @Override
    public ThingTypeUID getUID() {
        return (ThingTypeUID)super.getUID();
    }

    public String getBindingId() {
        return this.getUID().getBindingId();
    }

    public List<String> getSupportedBridgeTypeUIDs() {
        return this.supportedBridgeTypeUIDs;
    }

    public List<ChannelDefinition> getChannelDefinitions() {
        return this.channelDefinitions;
    }

    public List<ChannelGroupDefinition> getChannelGroupDefinitions() {
        return this.channelGroupDefinitions;
    }

    public boolean hasConfigDescriptionURI() {
        return this.configDescriptionURI != null;
    }

    public URI getConfigDescriptionURI() {
        return this.configDescriptionURI;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public ChannelTypeUID getChannelTypeUID(ChannelUID channelUID) {
        if (!channelUID.isInGroup()) {
            for (ChannelDefinition channelDefinition : this.getChannelDefinitions()) {
                if (!channelDefinition.getId().equals(channelUID.getId())) continue;
                return channelDefinition.getChannelTypeUID();
            }
        } else {
            List<ChannelGroupDefinition> channelGroupDefinitions = this.getChannelGroupDefinitions();
            for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
                ChannelGroupType channelGroupType;
                if (!channelGroupDefinition.getId().equals(channelUID.getGroupId()) || (channelGroupType = TypeResolver.resolve(channelGroupDefinition.getTypeUID())) == null) continue;
                for (ChannelDefinition channelDefinition : channelGroupType.getChannelDefinitions()) {
                    if (!channelDefinition.getId().equals(channelUID.getIdWithoutGroup())) continue;
                    return channelDefinition.getChannelTypeUID();
                }
            }
        }
        return null;
    }

    public boolean isListed() {
        return this.listed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThingType other = (ThingType)obj;
        return this.getUID().equals(other.getUID());
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public String toString() {
        return this.getUID().toString();
    }
}

