/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.core.internal.folder;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.service.AbstractWatchQueueReader;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.LoggerFactory;

public class FolderObserver
extends AbstractWatchService
implements ManagedService {
    private ModelRepository modelRepo = null;
    private final Map<String, String[]> folderFileExtMap = new ConcurrentHashMap<String, String[]>();

    public void setModelRepository(ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
    }

    public void unsetModelRepository(ModelRepository modelRepo) {
        this.modelRepo = null;
    }

    public void activate() {
    }

    protected AbstractWatchQueueReader buildWatchQueueReader(WatchService watchService, Path toWatch) {
        return new WatchQueueReader(watchService, toWatch, this.folderFileExtMap, this.modelRepo);
    }

    protected String getSourcePath() {
        return ConfigConstants.getConfigFolder();
    }

    protected boolean watchSubDirectories() {
        return true;
    }

    protected void registerDirectory(Path subDir) throws IOException {
        String folderName;
        if (subDir != null && MapUtils.isNotEmpty(this.folderFileExtMap) && this.folderFileExtMap.containsKey(folderName = subDir.getFileName().toString())) {
            subDir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
    }

    public synchronized void updated(Dictionary config) throws ConfigurationException {
        if (config != null) {
            ConcurrentHashMap<String, String[]> previousFolderFileExtMap = new ConcurrentHashMap<String, String[]>(this.folderFileExtMap);
            this.folderFileExtMap.clear();
            Enumeration keys = config.keys();
            while (keys.hasMoreElements()) {
                String foldername = (String)keys.nextElement();
                if (foldername.equals("service.pid")) continue;
                String[] fileExts = ((String)config.get(foldername)).split(",");
                File folder = FolderObserver.getFile(foldername);
                if (folder.exists() && folder.isDirectory()) {
                    this.folderFileExtMap.put(foldername, fileExts);
                    continue;
                }
                this.logger.warn("Directory '{}' does not exist in '{}'. Please check your configuration settings!", (Object)foldername, (Object)ConfigConstants.getConfigFolder());
            }
            this.notifyUpdateToModelRepo(previousFolderFileExtMap);
            this.initializeWatchService();
        }
    }

    private void notifyUpdateToModelRepo(Map<String, String[]> previousFolderFileExtMap) {
        this.checkDeletedModels(previousFolderFileExtMap);
        if (MapUtils.isNotEmpty(this.folderFileExtMap)) {
            for (String folderName : this.folderFileExtMap.keySet()) {
                File folder;
                File[] files;
                String[] validExtension = this.folderFileExtMap.get(folderName);
                if (validExtension == null || validExtension.length <= 0 || (files = (folder = FolderObserver.getFile(folderName)).listFiles(new FileExtensionsFilter(validExtension))) == null || files.length <= 0) continue;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    FolderObserver.checkFile(this.modelRepo, file, StandardWatchEventKinds.ENTRY_CREATE);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkDeletedModels(Map<String, String[]> previousFolderFileExtMap) {
        block11: {
            block10: {
                if (MapUtils.isNotEmpty(previousFolderFileExtMap) == false) return;
                modelsToRemove = new LinkedList<E>();
                if (!MapUtils.isNotEmpty(this.folderFileExtMap)) break block10;
                folders = previousFolderFileExtMap.keySet();
                var5_4 = folders.iterator();
                if (true) ** GOTO lbl15
            }
            folders = previousFolderFileExtMap.keySet();
            var5_4 = folders.iterator();
            if (true) ** GOTO lbl31
            do {
                if (this.folderFileExtMap.containsKey(folder = var5_4.next()) || (models = this.modelRepo.getAllModelNamesOfType(folder)) == null) continue;
                modelsToRemove.addAll(Lists.newLinkedList(models));
lbl15:
                // 3 sources

            } while (var5_4.hasNext());
            break block11;
            do {
                folder = var5_4.next();
                var6_6 = FolderObserver.class;
                // MONITORENTER : org.eclipse.smarthome.model.core.internal.folder.FolderObserver.class
                models = this.modelRepo.getAllModelNamesOfType(folder);
                if (models != null) {
                    modelsToRemove.addAll(Lists.newLinkedList(models));
                }
                // MONITOREXIT : var6_6
lbl31:
                // 2 sources

            } while (var5_4.hasNext());
        }
        if (CollectionUtils.isNotEmpty(modelsToRemove) == false) return;
        for (String modelToRemove : modelsToRemove) {
            var5_4 = FolderObserver.class;
            // MONITORENTER : org.eclipse.smarthome.model.core.internal.folder.FolderObserver.class
            this.modelRepo.removeModel(modelToRemove);
            // MONITOREXIT : var5_4
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFile(ModelRepository modelRepo, File file, WatchEvent.Kind kind) {
        if (modelRepo != null && file != null) {
            try {
                Class<FolderObserver> clazz = FolderObserver.class;
                synchronized (FolderObserver.class) {
                    if ((kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) && file != null) {
                        modelRepo.addOrRefreshModel(file.getName(), FileUtils.openInputStream((File)file));
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE && file != null) {
                        modelRepo.removeModel(file.getName());
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(FolderObserver.class).warn("Cannot open file '" + file.getAbsolutePath() + "' for reading.", (Throwable)e);
            }
        }
        {
            return;
        }
    }

    private static File getFileByFileExtMap(Map<String, String[]> folderFileExtMap, String filename) {
        String extension;
        if (StringUtils.isNotBlank((String)filename) && MapUtils.isNotEmpty(folderFileExtMap) && StringUtils.isNotBlank((String)(extension = FolderObserver.getExtension(filename)))) {
            Set<Map.Entry<String, String[]>> entries = folderFileExtMap.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                if (!ArrayUtils.contains((Object[])entry.getValue(), (Object)extension)) continue;
                return new File(FolderObserver.getFile(entry.getKey()) + File.separator + filename);
            }
        }
        return null;
    }

    private static File getFile(String filename) {
        File folder = new File(String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + filename);
        return folder;
    }

    public static String getExtension(String filename) {
        String fileExt = filename.substring(filename.lastIndexOf(".") + 1);
        return fileExt;
    }

    protected class FileExtensionsFilter
    implements FilenameFilter {
        private String[] validExtensions;

        public FileExtensionsFilter(String[] validExtensions) {
            this.validExtensions = validExtensions;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.validExtensions != null && this.validExtensions.length > 0) {
                String[] stringArray = this.validExtensions;
                int n = this.validExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (name.toLowerCase().endsWith("." + extension)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private static class WatchQueueReader
    extends AbstractWatchQueueReader {
        private Map<String, String[]> folderFileExtMap = new ConcurrentHashMap<String, String[]>();
        private ModelRepository modelRepo = null;

        public WatchQueueReader(WatchService watchService, Path dirToWatch, Map<String, String[]> folderFileExtMap, ModelRepository modelRepo) {
            super(watchService, dirToWatch);
            this.folderFileExtMap = folderFileExtMap;
            this.modelRepo = modelRepo;
        }

        protected void processWatchEvent(WatchEvent<?> event, WatchEvent.Kind<?> kind, Path path) {
            File toCheck = FolderObserver.getFileByFileExtMap(this.folderFileExtMap, path.toString());
            if (toCheck != null) {
                FolderObserver.checkFile(this.modelRepo, toCheck, kind);
            }
        }
    }
}

