/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.designer.ui.internal.views;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.eclipse.smarthome.designer.core.CoreActivator;
import org.eclipse.smarthome.designer.ui.UIActivator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ItemView
extends ViewPart {
    public static final String ID = "org.eclipse.smarthome.designer.ui.ItemView";
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider,
    ItemRegistryChangeListener {
        private Object invisibleRoot;
        private ItemRegistry registry;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
            this.registry = null;
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(ItemView.this.getViewSite())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent == this.invisibleRoot) {
                if (this.registry != null) {
                    return this.getRootGroups(this.registry.getItems());
                }
            } else if (parent instanceof GroupItem) {
                GroupItem group = (GroupItem)parent;
                return group.getMembers().toArray();
            }
            return new Object[0];
        }

        private Object[] getRootGroups(Collection<Item> items) {
            LinkedList<GroupItem> allGroups = new LinkedList<GroupItem>();
            LinkedList<GroupItem> rootGroups = new LinkedList<GroupItem>();
            for (Item item : items) {
                if (!(item instanceof GroupItem)) continue;
                allGroups.add((GroupItem)item);
            }
            for (GroupItem group1 : allGroups) {
                boolean found = false;
                for (GroupItem group2 : allGroups) {
                    if (!group2.getMembers().contains(group1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                rootGroups.add(group1);
            }
            return rootGroups.toArray(new GroupItem[rootGroups.size()]);
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        private void initialize() {
            this.registry = (ItemRegistry)UIActivator.itemRegistryTracker.getService();
            if (this.registry != null) {
                try {
                    CoreActivator.updateFolderObserver();
                }
                catch (IOException iOException) {}
                this.registry.addRegistryChangeListener((RegistryChangeListener)this);
                this.invisibleRoot = new Object();
                this.allItemsChanged(null);
            }
        }

        public void allItemsChanged(Collection<String> oldItemNames) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ItemView.this.viewer.refresh();
                    }
                });
            }
        }

        public void added(Item item) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ItemView.this.viewer.refresh();
                }
            });
        }

        public void removed(Item item) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ItemView.this.viewer.refresh();
                }
            });
        }

        public void updated(Item oldItem, Item item) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ItemView.this.viewer.refresh();
                }
            });
        }
    }

    static class ViewLabelProvider
    extends LabelProvider {
        private Map<String, Image> imageCache = new HashMap<String, Image>();

        ViewLabelProvider() {
        }

        public void dispose() {
            for (Image image : this.imageCache.values()) {
                image.dispose();
            }
        }

        public String getText(Object obj) {
            if (obj instanceof Item) {
                Item item = (Item)obj;
                return item.getName();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = null;
            if (obj instanceof GroupItem) {
                imageKey = "IMG_OBJ_FOLDER";
            } else {
                String imgName = obj.getClass().getSimpleName().replace("Item", "").toLowerCase();
                Image image = this.imageCache.get(imgName);
                if (image == null) {
                    ImageDescriptor imageDesc = UIActivator.getImageDescriptor("icons/" + imgName + ".png");
                    if (imageDesc != null) {
                        image = imageDesc.createImage();
                        this.imageCache.put(imgName, image);
                        return image;
                    }
                } else {
                    return image;
                }
                imageKey = "IMG_OBJ_ELEMENTS";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

