/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.interpreter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.model.script.engine.IItemRegistryProvider;
import org.eclipse.smarthome.model.script.lib.NumberExtensions;
import org.eclipse.smarthome.model.script.scoping.StateAndCommandProvider;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.impl.XbaseInterpreter;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ScriptInterpreter
extends XbaseInterpreter {
    @Inject
    private IItemRegistryProvider itemRegistryProvider;
    @Inject
    private StateAndCommandProvider stateAndCommandProvider;
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;

    protected Object _invokeFeature(JvmField jvmField, XAbstractFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        boolean _notEquals;
        Object _xblockexpression = null;
        Set _sourceElements = this._iJvmModelAssociations.getSourceElements((EObject)jvmField);
        EObject sourceElement = (EObject)IterableExtensions.head((Iterable)_sourceElements);
        Object _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)sourceElement, null);
        if (_notEquals) {
            Object _xblockexpression_1 = null;
            String _simpleName = jvmField.getSimpleName();
            QualifiedName _create = QualifiedName.create((String)_simpleName);
            Object value = context.getValue(_create);
            Object _elvis = null;
            if (value != null) {
                _elvis = value;
            } else {
                Type _xblockexpression_2 = null;
                String fieldName = jvmField.getSimpleName();
                Type _elvis_1 = null;
                Type _stateOrCommand = this.getStateOrCommand(fieldName);
                if (_stateOrCommand != null) {
                    _elvis_1 = _stateOrCommand;
                } else {
                    Item _item = this.getItem(fieldName);
                    _elvis_1 = _item;
                }
                _xblockexpression_2 = _elvis_1;
                _elvis = _xblockexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _elvis;
        } else {
            _xifexpression = super._invokeFeature(jvmField, featureCall, receiver, context, indicator);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Object invokeFeature(JvmIdentifiableElement feature, XAbstractFeatureCall featureCall, Object receiverObj, IEvaluationContext context, CancelIndicator indicator) {
        boolean _eIsProxy;
        Object _xblockexpression = null;
        boolean _and = false;
        boolean _notEquals = !Objects.equal((Object)feature, null);
        _and = !_notEquals ? false : (_eIsProxy = feature.eIsProxy());
        if (_and) {
            String _string = featureCall.toString();
            String _plus = "The name '" + _string;
            String _plus_1 = String.valueOf(_plus) + "' cannot be resolved to an item or type.";
            throw new RuntimeException(_plus_1);
        }
        _xblockexpression = super.invokeFeature(feature, featureCall, receiverObj, context, indicator);
        return _xblockexpression;
    }

    protected Type getStateOrCommand(String name) {
        Iterable<Type> _allTypes = this.stateAndCommandProvider.getAllTypes();
        for (Type type : _allTypes) {
            String _string = type.toString();
            boolean _equals = Objects.equal((Object)_string, (Object)name);
            if (!_equals) continue;
            return type;
        }
        return null;
    }

    protected Item getItem(String name) {
        ItemRegistry itemRegistry = (ItemRegistry)this.itemRegistryProvider.get();
        try {
            return itemRegistry.getItem(name);
        }
        catch (Throwable _t) {
            if (_t instanceof ItemNotFoundException) {
                ItemNotFoundException cfr_ignored_0 = (ItemNotFoundException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean eq(Object a, Object b) {
        boolean _and = false;
        _and = !(a instanceof Type) ? false : b instanceof Number;
        if (_and) {
            return NumberExtensions.operator_equals((Type)a, (Number)b);
        }
        boolean _and_1 = false;
        _and_1 = !(a instanceof Number) ? false : b instanceof Type;
        if (_and_1) {
            return NumberExtensions.operator_equals((Type)b, (Number)a);
        }
        return super.eq(a, b);
    }

    public Object _assignValueTo(JvmField jvmField, XAbstractFeatureCall assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        boolean _notEquals;
        Object _xblockexpression = null;
        Set _sourceElements = this._iJvmModelAssociations.getSourceElements((EObject)jvmField);
        EObject sourceElement = (EObject)IterableExtensions.head((Iterable)_sourceElements);
        Object _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)sourceElement, null);
        if (_notEquals) {
            Object _xblockexpression_1 = null;
            String _simpleName = jvmField.getSimpleName();
            QualifiedName _create = QualifiedName.create((String)_simpleName);
            context.assignValue(_create, value);
            _xifexpression = _xblockexpression_1 = value;
        } else {
            _xifexpression = super._assignValueTo(jvmField, assignment, value, context, indicator);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

