/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.firmware;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Firmware
implements Comparable<Firmware> {
    private static final Logger logger = LoggerFactory.getLogger(Firmware.class);
    private final FirmwareUID uid;
    private final String vendor;
    private final String model;
    private final String description;
    private final String version;
    private final String prerequisiteVersion;
    private final String changelog;
    private final URL onlineChangelog;
    private final transient InputStream inputStream;
    private final String md5Hash;
    private transient byte[] bytes;
    private final Version internalVersion;
    private final Version internalPrerequisiteVersion;

    private Firmware(Builder builder) {
        this.uid = builder.uid;
        this.version = builder.uid.getFirmwareVersion();
        this.vendor = builder.vendor;
        this.model = builder.model;
        this.description = builder.description;
        this.prerequisiteVersion = builder.prerequisiteVersion;
        this.changelog = builder.changelog;
        this.onlineChangelog = builder.onlineChangelog;
        this.inputStream = builder.inputStream;
        this.md5Hash = builder.md5Hash;
        this.internalVersion = new Version(this.version);
        this.internalPrerequisiteVersion = this.prerequisiteVersion != null ? new Version(this.prerequisiteVersion) : null;
    }

    public FirmwareUID getUID() {
        return this.uid;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPrerequisiteVersion() {
        return this.prerequisiteVersion;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public URL getOnlineChangelog() {
        return this.onlineChangelog;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public synchronized byte[] getBytes() {
        if (this.inputStream == null) {
            return null;
        }
        if (this.bytes == null) {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (DigestInputStream dis = new DigestInputStream(this.inputStream, md);){
                    this.bytes = ByteStreams.toByteArray((InputStream)dis);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioEx) {
                logger.error(String.format("Cannot read firmware with UID %s.", this.uid), (Throwable)ioEx);
                return null;
            }
            try {
                byte[] digest = md.digest();
                if (this.md5Hash != null && digest != null) {
                    StringBuilder digestString = new StringBuilder();
                    byte[] byArray = digest;
                    int n = digest.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        digestString.append(String.format("%02x", b));
                        ++n2;
                    }
                    if (!this.md5Hash.equals(digestString.toString())) {
                        this.bytes = null;
                        throw new IllegalStateException(String.format("Invalid MD5 checksum. Expected %s, but was %s.", this.md5Hash, digestString));
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Cannot calculate MD5 checksum.", (Throwable)e);
                this.bytes = null;
                return null;
            }
        }
        return this.bytes;
    }

    public boolean isSuccessorVersion(String firmwareVersion) {
        if (firmwareVersion == null) {
            return false;
        }
        return this.internalVersion.compare(new Version(firmwareVersion)) > 0;
    }

    public boolean isPrerequisteVersion(String firmwareVersion) {
        if (this.internalPrerequisiteVersion == null || firmwareVersion == null) {
            return false;
        }
        return new Version(firmwareVersion).compare(this.internalPrerequisiteVersion) >= 0;
    }

    @Override
    public int compareTo(Firmware firmware) {
        return -this.internalVersion.compare(new Version(firmware.getVersion()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changelog == null ? 0 : this.changelog.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.md5Hash == null ? 0 : this.md5Hash.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.onlineChangelog == null ? 0 : this.onlineChangelog.hashCode());
        result = 31 * result + (this.prerequisiteVersion == null ? 0 : this.prerequisiteVersion.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        result = 31 * result + (this.vendor == null ? 0 : this.vendor.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Firmware other = (Firmware)obj;
        if (this.changelog == null ? other.changelog != null : !this.changelog.equals(other.changelog)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.md5Hash == null ? other.md5Hash != null : !this.md5Hash.equals(other.md5Hash)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.onlineChangelog == null ? other.onlineChangelog != null : !this.onlineChangelog.equals(other.onlineChangelog)) {
            return false;
        }
        if (this.prerequisiteVersion == null ? other.prerequisiteVersion != null : !this.prerequisiteVersion.equals(other.prerequisiteVersion)) {
            return false;
        }
        if (this.uid == null ? other.uid != null : !this.uid.equals(other.uid)) {
            return false;
        }
        if (this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "Firmware [uid=" + this.uid + ", vendor=" + this.vendor + ", model=" + this.model + ", description=" + this.description + ", version=" + this.version + ", prerequisiteVersion=" + this.prerequisiteVersion + ", changelog=" + this.changelog + ", onlineChangelog=" + this.onlineChangelog + ", md5Hash=" + this.md5Hash + "]";
    }

    /* synthetic */ Firmware(Builder builder, Firmware firmware) {
        this(builder);
    }

    public static final class Builder {
        private final FirmwareUID uid;
        private String vendor;
        private String model;
        private String description;
        private String prerequisiteVersion;
        private String changelog;
        private URL onlineChangelog;
        private transient InputStream inputStream;
        private String md5Hash;

        public Builder(FirmwareUID uid) {
            Preconditions.checkNotNull((Object)uid, (Object)"Firmware UID must not be null.");
            this.uid = uid;
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withPrerequisiteVersion(String prerequisiteVersion) {
            this.prerequisiteVersion = prerequisiteVersion;
            return this;
        }

        public Builder withChangelog(String changelog) {
            this.changelog = changelog;
            return this;
        }

        public Builder withOnlineChangelog(URL onlineChangelog) {
            this.onlineChangelog = onlineChangelog;
            return this;
        }

        public Builder withInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder withMd5Hash(String md5Hash) {
            this.md5Hash = md5Hash;
            return this;
        }

        public Firmware build() {
            return new Firmware(this, null);
        }
    }

    private static class Version {
        private static final int NO_INT = -1;
        private final String[] parts;

        private Version(String versionString) {
            this.parts = versionString.split("-|_|\\.");
        }

        private int compare(Version theVersion) {
            int max = Math.max(this.parts.length, theVersion.parts.length);
            int i = 0;
            while (i < max) {
                String partA = i < this.parts.length ? this.parts[i] : null;
                String partB = i < theVersion.parts.length ? theVersion.parts[i] : null;
                Integer intA = partA != null && this.isInt(partA) ? Integer.parseInt(partA) : -1;
                Integer intB = partB != null && this.isInt(partB) ? Integer.parseInt(partB) : -1;
                if (intA != -1 && intB != -1) {
                    if (intA < intB) {
                        return -1;
                    }
                    if (intA > intB) {
                        return 1;
                    }
                } else if (partA == null || partB == null) {
                    if (partA == null) {
                        return -1;
                    }
                    if (partB == null) {
                        return 1;
                    }
                } else {
                    int result = partA.compareTo(partB);
                    if (result != 0) {
                        return result;
                    }
                }
                ++i;
            }
            return 0;
        }

        private boolean isInt(String s) {
            return s.matches("^-?\\d+$");
        }
    }
}

