/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ThingTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.TypeResolver;

public class ThingTypeRegistry {
    private List<ThingTypeProvider> thingTypeProviders = new CopyOnWriteArrayList<ThingTypeProvider>();

    public List<ThingType> getThingTypes(Locale locale) {
        ArrayList<ThingType> thingTypes = new ArrayList<ThingType>();
        for (ThingTypeProvider thingTypeProvider : this.thingTypeProviders) {
            thingTypes.addAll(thingTypeProvider.getThingTypes(locale));
        }
        return Collections.unmodifiableList(thingTypes);
    }

    public List<ThingType> getThingTypes() {
        return this.getThingTypes((Locale)null);
    }

    public List<ThingType> getThingTypes(String bindingId, Locale locale) {
        ArrayList thingTypesForBinding = Lists.newArrayList();
        for (ThingType thingType : this.getThingTypes()) {
            if (!thingType.getBindingId().equals(bindingId)) continue;
            thingTypesForBinding.add(thingType);
        }
        return Collections.unmodifiableList(thingTypesForBinding);
    }

    public List<ThingType> getThingTypes(String bindingId) {
        return this.getThingTypes(bindingId, null);
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID, Locale locale) {
        for (ThingTypeProvider thingTypeProvider : this.thingTypeProviders) {
            ThingType thingType = thingTypeProvider.getThingType(thingTypeUID, locale);
            if (thingType == null) continue;
            return thingType;
        }
        return null;
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID) {
        return this.getThingType(thingTypeUID, null);
    }

    public ChannelType getChannelType(Channel channel) {
        return this.getChannelType(channel, null);
    }

    public ChannelType getChannelType(Channel channel, Locale locale) {
        ChannelTypeUID channelTypeUID = channel.getChannelTypeUID();
        if (channelTypeUID != null) {
            return TypeResolver.resolve(channelTypeUID, locale);
        }
        return null;
    }

    protected void addThingTypeProvider(ThingTypeProvider thingTypeProvider) {
        if (thingTypeProvider != null) {
            this.thingTypeProviders.add(thingTypeProvider);
        }
    }

    protected void removeThingTypeProvider(ThingTypeProvider thingTypeProvider) {
        if (thingTypeProvider != null) {
            this.thingTypeProviders.remove(thingTypeProvider);
        }
    }
}

