/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.voice.internal.extensions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.io.voice.text.InterpretationException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class InterpretConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    public InterpretConsoleCommandExtension() {
        super("interpret", "Interpret a command by a human language interpreter.");
    }

    public List<String> getUsages() {
        return Collections.singletonList(this.buildCommandUsage("<command>", "interprets the human language command"));
    }

    public void execute(String[] args, Console console) {
        if (args.length < 1) {
            console.println("Nothing to interpret");
            return;
        }
        StringBuilder sb = new StringBuilder(args[0]);
        int i = 1;
        while (i < args.length) {
            sb.append(" ");
            sb.append(args[i]);
            ++i;
        }
        String msg = sb.toString();
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        Collection refs = null;
        try {
            refs = context.getServiceReferences(HumanLanguageInterpreter.class, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (refs != null && refs.size() > 0) {
            try {
                HumanLanguageInterpreter interpreter = (HumanLanguageInterpreter)context.getService((ServiceReference)refs.iterator().next());
                Locale locale = this.pickLanguage(interpreter.getSupportedLocales());
                console.println(interpreter.interpret(locale, msg));
            }
            catch (InterpretationException ie) {
                console.println(ie.getMessage());
            }
        } else {
            console.println("No human language interpreter available - tried to interpret: " + msg);
        }
    }

    private Locale pickLanguage(Set<Locale> locales) {
        if (locales == null || locales.size() == 0) {
            return Locale.ENGLISH;
        }
        Locale locale = Locale.getDefault();
        if (locales.contains(locale)) {
            return locale;
        }
        String language = locale.getLanguage();
        Locale first = null;
        for (Locale l : locales) {
            if (first == null) {
                first = l;
            }
            if (!language.equals(l.getLanguage())) continue;
            return l;
        }
        return first;
    }
}

