/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ExpressionInputDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class StringValueInputDialog
extends ExpressionInputDialog {
    private Group fTextGroup;
    private TextViewer fTextViewer;
    private Button fTextButton;
    private Button fEvaluationButton;
    private Button fWrapText;
    private boolean fUseLiteralValue = true;
    private static final String USE_EVALUATION = "USE_EVALUATION";
    private static final String WRAP_TEXT = "WRAP_TEXT";

    protected StringValueInputDialog(Shell parentShell, IJavaVariable variable) {
        super(parentShell, variable);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getHelpSystem().setHelp((Control)parent, IJavaDebugHelpContextIds.STRING_VALUE_INPUT_DIALOG);
        return control;
    }

    protected Composite createInputArea(Composite parent) {
        Composite composite = super.createInputArea(parent);
        this.createRadioButtons(parent);
        return composite;
    }

    protected void populateInputArea(Composite parent) {
        super.populateInputArea(parent);
        this.createTextViewer(parent);
        boolean useEvaluation = false;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            useEvaluation = settings.getBoolean(USE_EVALUATION);
        }
        this.setTextViewerVisible(!useEvaluation);
        this.setSourceViewerVisible(useEvaluation);
        this.fUseLiteralValue = !useEvaluation;
        this.fEvaluationButton.setSelection(useEvaluation);
        this.fTextButton.setSelection(!useEvaluation);
    }

    private void createTextViewer(Composite parent) {
        this.fTextGroup = SWTFactory.createGroup((Composite)parent, (String)ActionMessages.StringValueInputDialog_0, (int)1, (int)1, (int)1808);
        this.fTextViewer = new TextViewer((Composite)this.fTextGroup, 2818);
        this.fTextViewer.setDocument((IDocument)new Document());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 150;
        this.fTextViewer.getTextWidget().setLayoutData((Object)gridData);
        try {
            String valueString = this.fVariable.getValue().getValueString();
            this.fTextViewer.getDocument().set(valueString);
            this.fTextViewer.setSelectedRange(0, valueString.length());
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.fTextViewer.getControl().setFocus();
        boolean wrap = true;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            wrap = settings.getBoolean(WRAP_TEXT);
        }
        this.fWrapText = SWTFactory.createCheckButton((Composite)this.fTextGroup, (String)ActionMessages.StringValueInputDialog_4, null, (boolean)wrap, (int)1);
        this.updateWordWrap();
        this.fWrapText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInputDialog.this.updateWordWrap();
            }
        });
        IDocumentListener listener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                StringValueInputDialog.this.refreshValidState(StringValueInputDialog.this.fTextViewer);
            }
        };
        this.fTextViewer.getDocument().addDocumentListener(listener);
    }

    private void updateWordWrap() {
        this.fTextViewer.getTextWidget().setWordWrap(this.fWrapText.getSelection());
    }

    protected void createRadioButtons(Composite parent) {
        this.fTextButton = SWTFactory.createRadioButton((Composite)parent, (String)ActionMessages.StringValueInputDialog_1);
        this.fTextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringValueInputDialog.this.handleRadioSelectionChanged();
            }
        });
        this.fEvaluationButton = SWTFactory.createRadioButton((Composite)parent, (String)ActionMessages.StringValueInputDialog_2);
    }

    private void handleRadioSelectionChanged() {
        boolean literal = this.fTextButton.getSelection();
        if (literal != this.fUseLiteralValue) {
            this.fUseLiteralValue = literal;
            if (this.fUseLiteralValue) {
                this.setSourceViewerVisible(false);
                this.setTextViewerVisible(true);
            } else {
                this.setTextViewerVisible(false);
                this.setSourceViewerVisible(true);
            }
            this.fInputArea.layout(true, true);
            this.refreshValidState();
        }
    }

    protected void setTextViewerVisible(boolean value) {
        if (this.fTextGroup != null) {
            this.fTextGroup.setVisible(value);
            GridData data = (GridData)this.fTextGroup.getLayoutData();
            data.exclude = !value;
        }
    }

    protected void refreshValidState() {
        if (this.isUseLiteralValue()) {
            this.refreshValidState(this.fTextViewer);
        } else {
            super.refreshValidState();
        }
    }

    protected void okPressed() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            settings = JDIDebugUIPlugin.getDefault().getDialogSettings().addNewSection(this.getDialogSettingsSectionName());
        }
        settings.put(USE_EVALUATION, this.fEvaluationButton.getSelection());
        if (this.fWrapText != null) {
            settings.put(WRAP_TEXT, this.fWrapText.getSelection());
        }
        super.okPressed();
    }

    public boolean isUseLiteralValue() {
        return this.fUseLiteralValue;
    }

    protected String getText() {
        if (this.fTextButton.getSelection()) {
            return this.fTextViewer.getDocument().get();
        }
        return super.getText();
    }

    protected IDialogSettings getDialogSettings() {
        return JDIDebugUIPlugin.getDefault().getDialogSettings().getSection(this.getDialogSettingsSectionName());
    }

    protected String getDialogSettingsSectionName() {
        return "STRING_VALUE_INPUT_DIALOG";
    }
}

