/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.i18n;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.smarthome.core.common.osgi.ResolvedBundleTracker;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.internal.i18n.LanguageResourceBundleManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ResourceBundleTracker
extends ResolvedBundleTracker {
    private LocaleProvider localeProvider;
    private Map<Bundle, LanguageResourceBundleManager> bundleLanguageResourceMap;

    public ResourceBundleTracker(BundleContext bundleContext, LocaleProvider localeProvider) throws IllegalArgumentException {
        super(bundleContext);
        this.localeProvider = localeProvider;
        this.bundleLanguageResourceMap = new LinkedHashMap<Bundle, LanguageResourceBundleManager>();
    }

    @Override
    public synchronized void open() {
        super.open();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.bundleLanguageResourceMap.clear();
    }

    @Override
    public synchronized boolean addingBundle(Bundle bundle) {
        LanguageResourceBundleManager languageResource;
        if (!this.bundleLanguageResourceMap.containsKey(bundle) && (languageResource = new LanguageResourceBundleManager(this.localeProvider, bundle)).containsResources()) {
            this.bundleLanguageResourceMap.put(bundle, languageResource);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removedBundle(Bundle bundle) {
        LanguageResourceBundleManager languageResource = this.bundleLanguageResourceMap.remove(bundle);
        if (languageResource != null) {
            languageResource.clearCache();
        }
    }

    public LanguageResourceBundleManager getLanguageResource(Bundle bundle) {
        if (bundle != null) {
            return this.bundleLanguageResourceMap.get(bundle);
        }
        return null;
    }

    public Collection<LanguageResourceBundleManager> getAllLanguageResources() {
        return this.bundleLanguageResourceMap.values();
    }
}

