/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.persistence.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.persistence.internal.PersistenceManager;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceConfiguration;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceModel;
import org.eclipse.smarthome.model.persistence.persistence.Strategy;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistItemsJob
implements Job {
    private final Logger logger = LoggerFactory.getLogger(PersistItemsJob.class);
    public static final String JOB_DATA_PERSISTMODEL = "model";
    public static final String JOB_DATA_STRATEGYNAME = "strategy";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String modelName = (String)context.getJobDetail().getJobDataMap().get((Object)JOB_DATA_PERSISTMODEL);
        String strategyName = (String)context.getJobDetail().getJobDataMap().get((Object)JOB_DATA_STRATEGYNAME);
        PersistenceManager persistenceManager = PersistenceManager.getInstance();
        if (persistenceManager != null) {
            ModelRepository modelRepository = persistenceManager.modelRepository;
            PersistenceService persistenceService = persistenceManager.persistenceServices.get(modelName);
            if (modelRepository != null && persistenceService != null) {
                EObject model = modelRepository.getModel(String.valueOf(modelName) + ".persist");
                if (model instanceof PersistenceModel) {
                    PersistenceModel persistModel = (PersistenceModel)model;
                    for (PersistenceConfiguration config : persistModel.getConfigs()) {
                        if (!this.hasStrategy(persistModel, config, strategyName)) continue;
                        for (Item item : persistenceManager.getAllItems(config)) {
                            long startTime = System.currentTimeMillis();
                            persistenceService.store(item, config.getAlias());
                            this.logger.trace("Storing item '{}' with persistence service '{}' took {}ms", new Object[]{item.getName(), modelName, System.currentTimeMillis() - startTime});
                        }
                    }
                } else {
                    this.logger.debug("Persistence file '{}' does not exist", (Object)modelName);
                }
            }
        } else {
            this.logger.warn("Persistence manager is not available!");
        }
    }

    private boolean hasStrategy(PersistenceModel persistModel, PersistenceConfiguration config, String strategyName) {
        for (Strategy strategy : config.getStrategies()) {
            if (!strategyName.equals(strategy.getName())) continue;
            return true;
        }
        return config.getStrategies().isEmpty() && this.isDefault(persistModel, strategyName);
    }

    private boolean isDefault(PersistenceModel persistModel, String strategyName) {
        for (Strategy strategy : persistModel.getDefaults()) {
            if (!strategy.getName().equals(strategyName)) continue;
            return true;
        }
        return false;
    }
}

