/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.logging;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseLogAppender
extends AppenderSkeleton {
    private static final String LOG4J_BUNDLE_NAME = "org.apache.log4j";
    private static final Logger LOGGER = Logger.getLogger(EclipseLogAppender.class);
    private boolean initialized;
    private ILog log;

    private synchronized void ensureInitialized() {
        if (!this.initialized) {
            if (!Platform.isRunning()) {
                LOGGER.warn((Object)"You appear to be running outside Eclipse; you might want to remove the jar org.eclipse.xtext.logging*.jar from your classpath and supply your own log4j.properties.");
            } else {
                this.log = Platform.getLog((Bundle)Platform.getBundle((String)LOG4J_BUNDLE_NAME));
            }
            this.initialized = true;
        }
    }

    private ILog getLog() {
        this.ensureInitialized();
        return this.log;
    }

    protected void append(LoggingEvent event) {
        if (this.isDoLog(event.getLevel())) {
            String logString = this.layout.format(event);
            ILog myLog = this.getLog();
            if (myLog != null) {
                String loggerName = event.getLoggerName();
                int severity = this.mapLevel(event.getLevel());
                Throwable throwable = event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
                IStatus status = this.createStatus(severity, loggerName, logString, throwable);
                this.getLog().log(status);
            }
        }
    }

    private boolean isDoLog(Level level) {
        return level.toInt() >= 30000;
    }

    private int mapLevel(Level level) {
        switch (level.toInt()) {
            case 10000: 
            case 20000: {
                return 1;
            }
            case 30000: {
                return 2;
            }
            case 40000: 
            case 50000: {
                return 4;
            }
        }
        return 1;
    }

    private IStatus createStatus(int severity, String loggerName, String message, Throwable throwable) {
        return new Status(severity, LOG4J_BUNDLE_NAME, message, throwable);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

