/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.lib;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.types.Type;

public class NumberExtensions {
    public static final BigDecimal NULL_DEFINITION = new BigDecimal(0);

    public static BigDecimal operator_plus(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return yValue;
        }
        if (yValue == null) {
            return xValue;
        }
        return xValue.add(yValue);
    }

    public static BigDecimal operator_minus(Number x) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        if (xValue == null) {
            return xValue;
        }
        return xValue.negate();
    }

    public static BigDecimal operator_minus(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return NumberExtensions.operator_minus(yValue);
        }
        if (yValue == null) {
            return xValue;
        }
        return xValue.subtract(yValue);
    }

    public static BigDecimal operator_multiply(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return NULL_DEFINITION;
        }
        if (yValue == null) {
            return NULL_DEFINITION;
        }
        return xValue.multiply(yValue);
    }

    public static BigDecimal operator_divide(Number x, Number y) {
        BigDecimal xValue = NumberExtensions.numberToBigDecimal(x);
        BigDecimal yValue = NumberExtensions.numberToBigDecimal(y);
        if (xValue == null) {
            return NULL_DEFINITION.divide(yValue, 8, RoundingMode.HALF_UP);
        }
        if (yValue == null) {
            return xValue.divide(NULL_DEFINITION, 8, RoundingMode.HALF_UP);
        }
        return xValue.divide(yValue, 8, RoundingMode.HALF_UP);
    }

    public static boolean operator_equals(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue == null;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) == 0;
    }

    public static boolean operator_notEquals(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue != null;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) != 0;
    }

    public static boolean operator_lessThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return true;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) < 0;
    }

    public static boolean operator_greaterThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return false;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) > 0;
    }

    public static boolean operator_lessEqualsThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return true;
        }
        if (rightValue == null) {
            return false;
        }
        return leftValue.compareTo(rightValue) <= 0;
    }

    public static boolean operator_greaterEqualsThan(Number left, Number right) {
        BigDecimal leftValue = NumberExtensions.numberToBigDecimal(left);
        BigDecimal rightValue = NumberExtensions.numberToBigDecimal(right);
        if (leftValue == null) {
            return rightValue == null;
        }
        if (rightValue == null) {
            return true;
        }
        return leftValue.compareTo(rightValue) >= 0;
    }

    public static boolean operator_equals(Type type, Number x) {
        if (type != null && type instanceof DecimalType && x != null) {
            return ((DecimalType)type).toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) == 0;
        }
        return type == x;
    }

    public static boolean operator_notEquals(Type type, Number x) {
        if (type != null && type instanceof DecimalType && x != null) {
            return ((DecimalType)type).toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) != 0;
        }
        return type != x;
    }

    public static boolean operator_greaterThan(Type type, Number x) {
        if (type != null && type instanceof DecimalType && x != null) {
            return ((DecimalType)type).toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) > 0;
        }
        return false;
    }

    public static boolean operator_greaterEqualsThan(Type type, Number x) {
        if (type != null && type instanceof DecimalType && x != null) {
            return ((DecimalType)type).toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) >= 0;
        }
        return false;
    }

    public static boolean operator_lessThan(Type type, Number x) {
        if (type != null && type instanceof DecimalType && x != null) {
            return ((DecimalType)type).toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) < 0;
        }
        return false;
    }

    public static boolean operator_lessEqualsThan(Type type, Number x) {
        if (type != null && type instanceof DecimalType && x != null) {
            return ((DecimalType)type).toBigDecimal().compareTo(NumberExtensions.numberToBigDecimal(x)) <= 0;
        }
        return false;
    }

    public static BigDecimal numberToBigDecimal(Number number) {
        if (number != null) {
            return new BigDecimal(number.toString());
        }
        return null;
    }
}

