/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import java.util.List;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingLinkManager {
    private Logger logger = LoggerFactory.getLogger(ThingLinkManager.class);
    private ThingRegistry thingRegistry;
    private ManagedThingProvider managedThingProvider;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private boolean autoLinks = true;
    private final RegistryChangeListener<ItemChannelLink> itemChannelLinkRegistryChangeListener = new RegistryChangeListener<ItemChannelLink>(){

        public void added(ItemChannelLink itemChannelLink) {
            Channel channel;
            ChannelUID channelUID = itemChannelLink.getUID();
            Thing thing = ThingLinkManager.this.thingRegistry.get(channelUID.getThingUID());
            if (thing != null && (channel = thing.getChannel(channelUID.getId())) != null) {
                ThingLinkManager.this.informHandlerAboutLinkedChannel(thing, channel);
            }
        }

        public void removed(ItemChannelLink itemChannelLink) {
            Channel channel;
            ChannelUID channelUID = itemChannelLink.getUID();
            Thing thing = ThingLinkManager.this.thingRegistry.get(channelUID.getThingUID());
            if (thing != null && (channel = thing.getChannel(channelUID.getId())) != null) {
                ThingLinkManager.this.informHandlerAboutUnlinkedChannel(thing, channel);
            }
        }

        public void updated(ItemChannelLink oldElement, ItemChannelLink element) {
            if (!oldElement.equals(element)) {
                this.removed(oldElement);
                this.added(element);
            }
        }
    };
    private final ProviderChangeListener<Thing> managedThingProviderListener = new ProviderChangeListener<Thing>(){

        public void added(Provider<Thing> provider, Thing thing) {
            List<Channel> channels = thing.getChannels();
            for (Channel channel : channels) {
                this.createLinkIfNotAdvanced(channel);
            }
        }

        private void createLinkIfNotAdvanced(Channel channel) {
            if (ThingLinkManager.this.autoLinks) {
                ChannelType type;
                if (channel.getChannelTypeUID() != null && (type = TypeResolver.resolve(channel.getChannelTypeUID())) != null && type.isAdvanced()) {
                    return;
                }
                ItemChannelLink link = new ItemChannelLink(this.deriveItemName(channel.getUID()), channel.getUID());
                ThingLinkManager.this.itemChannelLinkRegistry.add(link);
            }
        }

        public void removed(Provider<Thing> provider, Thing thing) {
            List<Channel> channels = thing.getChannels();
            for (Channel channel : channels) {
                ItemChannelLink link = new ItemChannelLink(this.deriveItemName(channel.getUID()), channel.getUID());
                ThingLinkManager.this.itemChannelLinkRegistry.remove(link.getID());
            }
        }

        public void updated(Provider<Thing> provider, Thing oldThing, Thing newThing) {
            for (Channel channel : oldThing.getChannels()) {
                if (newThing.getChannel(channel.getUID().getId()) != null) continue;
                ItemChannelLink link = new ItemChannelLink(this.deriveItemName(channel.getUID()), channel.getUID());
                ThingLinkManager.this.itemChannelLinkRegistry.remove(link.getID());
            }
            for (Channel channel : newThing.getChannels()) {
                if (oldThing.getChannel(channel.getUID().getId()) != null) continue;
                this.createLinkIfNotAdvanced(channel);
            }
        }

        private String deriveItemName(ChannelUID uid) {
            return uid.getAsString().replaceAll("[^a-zA-Z0-9_]", "_");
        }
    };

    protected void activate(ComponentContext context) {
        this.modified(context);
        this.itemChannelLinkRegistry.addRegistryChangeListener(this.itemChannelLinkRegistryChangeListener);
        this.managedThingProvider.addProviderChangeListener(this.managedThingProviderListener);
    }

    protected void modified(ComponentContext context) {
        if (context != null) {
            Object value = context.getProperties().get("autoLinks");
            this.autoLinks = value == null || !value.toString().equals("false");
        }
    }

    protected void deactivate() {
        this.itemChannelLinkRegistry.removeRegistryChangeListener(this.itemChannelLinkRegistryChangeListener);
        this.managedThingProvider.removeProviderChangeListener(this.managedThingProviderListener);
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    public boolean isAutoLinksEnabled() {
        return this.autoLinks;
    }

    private void informHandlerAboutLinkedChannel(Thing thing, Channel channel) {
        ThingHandler handler = thing.getHandler();
        if (handler != null) {
            try {
                handler.channelLinked(channel.getUID());
            }
            catch (Exception ex) {
                this.logger.error("Exception occured while informing handler:" + ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.logger.trace("Can not inform handler about linked channel, because no handler is assigned to the thing {}.", (Object)thing.getUID());
        }
    }

    private void informHandlerAboutUnlinkedChannel(Thing thing, Channel channel) {
        ThingHandler handler = thing.getHandler();
        if (handler != null) {
            try {
                handler.channelUnlinked(channel.getUID());
            }
            catch (Exception ex) {
                this.logger.error("Exception occured while informing handler:" + ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.logger.trace("Can not inform handler about unlinked channel, because no handler is assigned to the thing {}.", (Object)thing.getUID());
        }
    }
}

