/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer tree;
    private IWorkingSet workingSet;
    private boolean firstCheck = false;

    public ResourceWorkingSetPage() {
        super("resourceWorkingSetPage", IDEWorkbenchMessages.ResourceWorkingSetPage_title, IDEInternalWorkbenchImages.getImageDescriptor("IMG_WIZBAN_EXPORTZIP_WIZ"));
        this.setDescription(IDEWorkbenchMessages.ResourceWorkingSetPage_description);
    }

    private void addWorkingSetElements(List collectedResources, IContainer container) {
        IAdaptable[] elements = this.workingSet.getElements();
        IPath containerPath = container.getFullPath();
        int i = 0;
        while (i < elements.length) {
            IPath resourcePath;
            IResource resource = null;
            resource = elements[i] instanceof IResource ? (IResource)elements[i] : (IResource)elements[i].getAdapter(IResource.class);
            if (resource != null && containerPath.isPrefixOf(resourcePath = resource.getFullPath())) {
                collectedResources.add(elements[i]);
            }
            ++i;
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.working_set_resource_page");
        Label label = new Label(composite, 64);
        label.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_message);
        GridData data = new GridData(772);
        label.setLayoutData((Object)data);
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite, 64);
        label.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_label_tree);
        data = new GridData(772);
        label.setLayoutData((Object)data);
        this.tree = new CheckboxTreeViewer(composite);
        this.tree.setUseHashlookup(true);
        WorkbenchContentProvider treeContentProvider = new WorkbenchContentProvider();
        this.tree.setContentProvider((IContentProvider)treeContentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), IDEWorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tree.setInput((Object)IDEWorkbenchPlugin.getPluginWorkspace().getRoot());
        this.tree.setComparator((ViewerComparator)new ResourceComparator(1));
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.tree.getControl().setLayoutData((Object)data);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResourceWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (!ResourceWorkingSetPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)ResourceWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ResourceWorkingSetPage.this.setSubtreeChecked((IContainer)element, ResourceWorkingSetPage.this.tree.getChecked(element), false);
                        }
                    });
                }
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_selectAll_label);
        selectAllButton.setToolTipText(IDEWorkbenchMessages.ResourceWorkingSetPage_selectAll_toolTip);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter((ITreeContentProvider)treeContentProvider){
            private final /* synthetic */ ITreeContentProvider val$treeContentProvider;
            {
                this.val$treeContentProvider = iTreeContentProvider;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                BusyIndicator.showWhile((Display)ResourceWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ResourceWorkingSetPage.this.tree.setCheckedElements(val$treeContentProvider.getElements(ResourceWorkingSetPage.this.tree.getInput()));
                        ResourceWorkingSetPage.this.setSubtreeChecked((IContainer)ResourceWorkingSetPage.this.tree.getInput(), true, false);
                    }
                });
                ResourceWorkingSetPage.this.validateInput();
            }
        });
        this.setButtonLayoutData(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(IDEWorkbenchMessages.ResourceWorkingSetPage_deselectAll_label);
        deselectAllButton.setToolTipText(IDEWorkbenchMessages.ResourceWorkingSetPage_deselectAll_toolTip);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter((ITreeContentProvider)treeContentProvider){
            private final /* synthetic */ ITreeContentProvider val$treeContentProvider;
            {
                this.val$treeContentProvider = iTreeContentProvider;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                BusyIndicator.showWhile((Display)ResourceWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ResourceWorkingSetPage.this.tree.setCheckedElements(val$treeContentProvider.getElements(ResourceWorkingSetPage.this.tree.getInput()));
                        ResourceWorkingSetPage.this.setSubtreeChecked((IContainer)ResourceWorkingSetPage.this.tree.getInput(), false, false);
                    }
                });
                ResourceWorkingSetPage.this.validateInput();
            }
        });
        this.setButtonLayoutData(deselectAllButton);
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
        Dialog.applyDialogFont((Control)composite);
    }

    private void findCheckedResources(List checkedResources, IContainer container) {
        IResource[] resources = null;
        try {
            resources = container.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), IDEWorkbenchMessages.ResourceWorkingSetPage_error, IDEWorkbenchMessages.ResourceWorkingSetPage_error_updateCheckedState);
        }
        int i = 0;
        while (i < resources.length) {
            if (this.tree.getGrayed((Object)resources[i])) {
                if (resources[i].isAccessible()) {
                    this.findCheckedResources(checkedResources, (IContainer)resources[i]);
                } else {
                    this.addWorkingSetElements(checkedResources, (IContainer)resources[i]);
                }
            } else if (this.tree.getChecked((Object)resources[i])) {
                checkedResources.add(resources[i]);
            }
            ++i;
        }
    }

    public void finish() {
        ArrayList resources = new ArrayList(10);
        this.findCheckedResources(resources, (IContainer)this.tree.getInput());
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(this.getWorkingSetName(), resources.toArray(new IAdaptable[resources.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(resources.toArray(new IAdaptable[resources.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IResource resource = (IResource)event.getElement();
                boolean state = event.getChecked();
                ResourceWorkingSetPage.this.tree.setGrayed((Object)resource, false);
                if (resource instanceof IContainer) {
                    ResourceWorkingSetPage.this.setSubtreeChecked((IContainer)resource, state, true);
                }
                ResourceWorkingSetPage.this.updateParentState(resource);
                ResourceWorkingSetPage.this.validateInput();
            }
        });
    }

    private void handleCoreException(CoreException exception, Shell shell, String title, String message) {
        IStatus status = exception.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.InternalError, (String)exception.getLocalizedMessage());
        }
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] items = null;
                if (ResourceWorkingSetPage.this.workingSet == null) {
                    IWorkbenchPage page = IDEWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page == null) {
                        return;
                    }
                    IWorkbenchPart part = page.getActivePart();
                    if (part == null) {
                        return;
                    }
                    ISelection selection = page.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        items = ((IStructuredSelection)selection).toArray();
                    }
                } else {
                    items = ResourceWorkingSetPage.this.workingSet.getElements();
                }
                if (items == null) {
                    return;
                }
                ResourceWorkingSetPage.this.tree.setCheckedElements(items);
                int i = 0;
                while (i < items.length) {
                    IAdaptable item = null;
                    if (items[i] instanceof IAdaptable) {
                        item = (IAdaptable)items[i];
                        IContainer container = null;
                        IResource resource = null;
                        container = item instanceof IContainer ? (IContainer)item : (IContainer)item.getAdapter(IContainer.class);
                        if (container != null) {
                            ResourceWorkingSetPage.this.setSubtreeChecked(container, true, true);
                        }
                        if ((resource = item instanceof IResource ? (IResource)item : (IResource)item.getAdapter(IResource.class)) != null && !resource.isAccessible()) {
                            IProject project = resource.getProject();
                            if (!ResourceWorkingSetPage.this.tree.getChecked((Object)project)) {
                                ResourceWorkingSetPage.this.tree.setGrayChecked((Object)project, true);
                            }
                        } else {
                            ResourceWorkingSetPage.this.updateParentState(resource);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.workingSet = workingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(workingSet.getName());
        }
    }

    private void setSubtreeChecked(IContainer container, boolean state, boolean checkExpandedState) {
        if (!container.isAccessible() || !this.tree.getExpandedState((Object)container) && state && checkExpandedState) {
            return;
        }
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), IDEWorkbenchMessages.ResourceWorkingSetPage_error, IDEWorkbenchMessages.ResourceWorkingSetPage_error_updateCheckedState);
        }
        int i = members.length - 1;
        while (i >= 0) {
            boolean elementGrayChecked;
            IResource element = members[i];
            boolean bl = elementGrayChecked = this.tree.getGrayed((Object)element) || this.tree.getChecked((Object)element);
            if (state) {
                this.tree.setChecked((Object)element, true);
                this.tree.setGrayed((Object)element, false);
            } else {
                this.tree.setGrayChecked((Object)element, false);
            }
            if (element instanceof IContainer && (state || elementGrayChecked)) {
                this.setSubtreeChecked((IContainer)element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(IResource child) {
        if (child == null || child.getParent() == null) {
            return;
        }
        IContainer parent = child.getParent();
        boolean childChecked = false;
        IResource[] members = null;
        try {
            members = parent.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), IDEWorkbenchMessages.ResourceWorkingSetPage_error, IDEWorkbenchMessages.ResourceWorkingSetPage_error_updateCheckedState);
        }
        int i = members.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked((Object)members[i]) || this.tree.getGrayed((Object)members[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.tree.setGrayChecked((Object)parent, childChecked);
        this.updateParentState((IResource)parent);
    }

    private void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.text.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_nameWhitespace;
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if (newText.equals("")) {
            errorMessage = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_workingSetExists;
                }
                ++i;
            }
        }
        if (infoMessage == null && this.tree.getCheckedElements().length == 0) {
            infoMessage = IDEWorkbenchMessages.ResourceWorkingSetPage_warning_resourceMustBeChecked;
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

