/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.eclipse.smarthome.core.thing.util.ThingHelper;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.thing.thing.ModelBridge;
import org.eclipse.smarthome.model.thing.thing.ModelChannel;
import org.eclipse.smarthome.model.thing.thing.ModelProperty;
import org.eclipse.smarthome.model.thing.thing.ModelPropertyContainer;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingModel;
import org.eclipse.xtend.lib.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericThingProvider
extends AbstractProvider<Thing>
implements ThingProvider,
ModelRepositoryChangeListener {
    private LocaleProvider localeProvider;
    private ModelRepository modelRepository;
    private ThingTypeRegistry thingTypeRegistry;
    private Map<String, Collection<Thing>> thingsMap = new ConcurrentHashMap<String, Collection<Thing>>();
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private final List<QueueContent> queue = new CopyOnWriteArrayList<QueueContent>();
    private Thread lazyRetryThread = null;
    private static final Logger logger = LoggerFactory.getLogger(GenericThingProvider.class);
    private final Runnable lazyRetryRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                logger.debug("Starting lazy retry thread");
                while (!GenericThingProvider.this.queue.isEmpty()) {
                    boolean _isEmpty_2;
                    boolean _not_2;
                    boolean _not;
                    boolean _isEmpty = GenericThingProvider.this.queue.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        boolean _not_1;
                        final ArrayList newThings = new ArrayList();
                        Procedures.Procedure1<QueueContent> _function = new Procedures.Procedure1<QueueContent>(){

                            public void apply(QueueContent qc) {
                                boolean _notEquals;
                                ThingTypeUID _thingTypeUID = qc.getThingTypeUID();
                                logger.trace("Searching thingHandlerFactory for thingType: {}", (Object)_thingTypeUID);
                                ThingHandlerFactory _thingHandlerFactory = qc.getThingHandlerFactory();
                                ThingTypeUID _thingTypeUID_1 = qc.getThingTypeUID();
                                Configuration _configuration = qc.getConfiguration();
                                ThingUID _thingUID = qc.getThingUID();
                                ThingUID _bridgeUID = qc.getBridgeUID();
                                Thing thing = _thingHandlerFactory.createThing(_thingTypeUID_1, _configuration, _thingUID, _bridgeUID);
                                boolean bl = _notEquals = !Objects.equal((Object)thing, null);
                                if (_notEquals) {
                                    GenericThingProvider.this.queue.remove(qc);
                                    String _label = qc.getLabel();
                                    thing.setLabel(_label);
                                    ThingUID _thingUID_1 = qc.getThingUID();
                                    logger.debug("Successfully loaded '{}' during retry", (Object)_thingUID_1);
                                    newThings.add(thing);
                                }
                            }
                        };
                        IterableExtensions.forEach((Iterable)GenericThingProvider.this.queue, (Procedures.Procedure1)_function);
                        boolean _isEmpty_1 = newThings.isEmpty();
                        boolean bl2 = _not_1 = !_isEmpty_1;
                        if (_not_1) {
                            Procedures.Procedure1<Thing> _function_1 = new Procedures.Procedure1<Thing>(){

                                public void apply(final Thing newThing) {
                                    boolean _notEquals;
                                    Functions.Function1<Thing, Boolean> _function_1;
                                    Set _keySet = GenericThingProvider.this.thingsMap.keySet();
                                    Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                                        public Boolean apply(String mName) {
                                            Functions.Function1<Thing, Boolean> _function;
                                            Collection _get = (Collection)GenericThingProvider.this.thingsMap.get(mName);
                                            Iterable _filter = IterableExtensions.filter((Iterable)_get, (Functions.Function1)(_function = new Functions.Function1<Thing, Boolean>(){

                                                public Boolean apply(Thing it) {
                                                    ThingUID _uID = it.getUID();
                                                    ThingUID _uID_1 = newThing.getUID();
                                                    return Objects.equal((Object)_uID, (Object)_uID_1);
                                                }
                                            }));
                                            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
                                            return !_isEmpty;
                                        }
                                    };
                                    String modelName = (String)IterableExtensions.findFirst(_keySet, (Functions.Function1)_function);
                                    Collection _get = (Collection)GenericThingProvider.this.thingsMap.get(modelName);
                                    Thing oldThing = (Thing)IterableExtensions.findFirst((Iterable)_get, (Functions.Function1)(_function_1 = new Functions.Function1<Thing, Boolean>(){

                                        public Boolean apply(Thing it) {
                                            ThingUID _uID = it.getUID();
                                            ThingUID _uID_1 = newThing.getUID();
                                            return Objects.equal((Object)_uID, (Object)_uID_1);
                                        }
                                    }));
                                    boolean bl = _notEquals = !Objects.equal((Object)oldThing, null);
                                    if (_notEquals) {
                                        boolean _not;
                                        Collection _get_1 = (Collection)GenericThingProvider.this.thingsMap.get(modelName);
                                        _get_1.remove(oldThing);
                                        Collection _get_2 = (Collection)GenericThingProvider.this.thingsMap.get(modelName);
                                        _get_2.add(newThing);
                                        ThingUID _uID = newThing.getUID();
                                        logger.debug("Refreshing thing '{}' after successful retry", (Object)_uID);
                                        boolean _equals = ThingHelper.equals((Thing)oldThing, (Thing)newThing);
                                        boolean bl2 = _not = !_equals;
                                        if (_not) {
                                            GenericThingProvider.this.notifyListenersAboutUpdatedElement(oldThing, newThing);
                                        }
                                    } else {
                                        ThingUID _uID_1 = newThing.getUID();
                                        String _format = String.format("Item %s not yet known", _uID_1);
                                        throw new IllegalStateException(_format);
                                    }
                                }
                            };
                            IterableExtensions.forEach(newThings, (Procedures.Procedure1)_function_1);
                        }
                    }
                    boolean bl3 = _not_2 = !(_isEmpty_2 = GenericThingProvider.this.queue.isEmpty());
                    if (!_not_2) continue;
                    Thread.sleep(1000L);
                }
                logger.debug("Lazy retry thread ran out of work. Good bye.");
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    };

    public void activate() {
        Iterable _allModelNamesOfType = this.modelRepository.getAllModelNamesOfType("things");
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                GenericThingProvider.this.createThingsFromModel(it);
            }
        };
        IterableExtensions.forEach((Iterable)_allModelNamesOfType, (Procedures.Procedure1)_function);
    }

    public Collection<Thing> getAll() {
        Collection<Collection<Thing>> _values = this.thingsMap.values();
        Iterable _flatten = Iterables.concat(_values);
        return IterableExtensions.toList((Iterable)_flatten);
    }

    private void createThingsFromModel(String modelName) {
        boolean _notEquals;
        logger.debug("Read things from model '{}'", (Object)modelName);
        final ArrayList things = CollectionLiterals.newArrayList((Object[])new Thing[0]);
        boolean bl = _notEquals = !Objects.equal((Object)this.modelRepository, null);
        if (_notEquals) {
            boolean _notEquals_1;
            EObject _model = this.modelRepository.getModel(modelName);
            ThingModel model = (ThingModel)_model;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)model, null);
            if (_notEquals_1) {
                EList<ModelThing> _things = model.getThings();
                Procedures.Procedure1<ModelThing> _function = new Procedures.Procedure1<ModelThing>(){

                    public void apply(ModelThing it) {
                        GenericThingProvider.this.createThing(it, null, things);
                    }
                };
                IterableExtensions.forEach(_things, (Procedures.Procedure1)_function);
            }
        }
        this.thingsMap.put(modelName, things);
    }

    private void createThing(ModelThing modelThing, Bridge parentBridge, Collection<Thing> thingList) {
        this.createThing(modelThing, parentBridge, thingList, null);
    }

    private void createThing(ModelThing modelThing, Bridge parentBridge, final Collection<Thing> thingList, final ThingHandlerFactory thingHandlerFactory) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _not_1;
        boolean _notEquals;
        ThingTypeUID thingTypeUID = null;
        ThingUID thingUID = null;
        ThingUID bridgeUID = null;
        boolean bl = _notEquals = !Objects.equal((Object)parentBridge, null);
        if (_notEquals) {
            ThingUID _uID;
            ThingUID _thingUID;
            ThingTypeUID _thingTypeUID_1;
            ThingTypeUID _thingTypeUID = parentBridge.getThingTypeUID();
            String bindingId = _thingTypeUID.getBindingId();
            String thingTypeId = modelThing.getThingTypeId();
            String thingId = modelThing.getThingId();
            thingTypeUID = _thingTypeUID_1 = new ThingTypeUID(bindingId, thingTypeId);
            List<String> _parentPath = this.getParentPath(parentBridge);
            thingUID = _thingUID = new ThingUID(thingTypeUID, thingId, (String[])Conversions.unwrapArray(_parentPath, String.class));
            bridgeUID = _uID = parentBridge.getUID();
        } else {
            String _bridgeUID_1;
            boolean _isEmpty;
            boolean _not;
            boolean _notEquals_1;
            ThingTypeUID _thingTypeUID_2;
            ThingUID _thingUID_1;
            String _id = modelThing.getId();
            thingUID = _thingUID_1 = new ThingUID(_id);
            String _bindingId = thingUID.getBindingId();
            String _thingTypeId = thingUID.getThingTypeId();
            thingTypeUID = _thingTypeUID_2 = new ThingTypeUID(_bindingId, _thingTypeId);
            boolean _and = false;
            String _bridgeUID = modelThing.getBridgeUID();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_bridgeUID, null);
            _and = !_notEquals_1 ? false : (_not = !(_isEmpty = (_bridgeUID_1 = modelThing.getBridgeUID()).isEmpty()));
            if (_and) {
                ThingUID _thingUID_2;
                String _bridgeUID_2 = modelThing.getBridgeUID();
                bridgeUID = _thingUID_2 = new ThingUID(_bridgeUID_2);
            }
        }
        boolean _isSupportedByThingHandlerFactory = this.isSupportedByThingHandlerFactory(thingTypeUID, thingHandlerFactory);
        boolean bl3 = _not_1 = !_isSupportedByThingHandlerFactory;
        if (_not_1) {
            return;
        }
        logger.trace("Creating thing for type '{}' with UID '{}.", (Object)thingTypeUID, (Object)thingUID);
        Configuration configuration = this.createConfiguration(modelThing);
        final ThingUID uid = thingUID;
        Functions.Function1<Thing, Boolean> _function = new Functions.Function1<Thing, Boolean>(){

            public Boolean apply(Thing it) {
                ThingUID _uID = it.getUID();
                return _uID.equals((Object)uid);
            }
        };
        boolean _exists = IterableExtensions.exists(thingList, (Functions.Function1)_function);
        if (_exists) {
            String _string = uid.toString();
            logger.debug("Thing already exists {}", (Object)_string);
            return;
        }
        ThingType thingType = this.getThingType(thingTypeUID);
        String _xifexpression = null;
        String _label = modelThing.getLabel();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_label, null);
        if (_notEquals_2) {
            _xifexpression = modelThing.getLabel();
        } else {
            String _label_1 = null;
            if (thingType != null) {
                _label_1 = thingType.getLabel();
            }
            _xifexpression = _label_1;
        }
        String label = _xifexpression;
        Thing thingFromHandler = this.getThingFromThingHandlerFactories(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
        Object _xifexpression_1 = null;
        _xifexpression_1 = modelThing instanceof ModelBridge ? BridgeBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID) : ThingBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID);
        BridgeBuilder thingBuilder = _xifexpression_1;
        thingBuilder.withConfiguration(configuration);
        thingBuilder.withBridge(bridgeUID);
        thingBuilder.withLabel(label);
        EList<ModelChannel> _channels = modelThing.getChannels();
        List _elvis = null;
        List _channelDefinitions = null;
        if (thingType != null) {
            _channelDefinitions = thingType.getChannelDefinitions();
        }
        if (_channelDefinitions != null) {
            _elvis = _channelDefinitions;
        } else {
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new ChannelDefinition[0]);
            _elvis = _newArrayList;
        }
        List<Channel> channels = this.createChannels(thingTypeUID, thingUID, (List<ModelChannel>)_channels, _elvis);
        thingBuilder.withChannels(channels);
        Thing thing = thingBuilder.build();
        boolean bl5 = _notEquals_3 = !Objects.equal((Object)thingFromHandler, null);
        if (_notEquals_3) {
            this.merge(thingFromHandler, thing);
        }
        Thing _elvis_1 = null;
        _elvis_1 = thingFromHandler != null ? thingFromHandler : thing;
        thingList.add(_elvis_1);
        if (modelThing instanceof ModelBridge) {
            Thing _elvis_2 = null;
            _elvis_2 = thingFromHandler != null ? thingFromHandler : thing;
            final Bridge bridge = (Bridge)_elvis_2;
            EList<ModelThing> _things = ((ModelBridge)modelThing).getThings();
            Procedures.Procedure1<ModelThing> _function_1 = new Procedures.Procedure1<ModelThing>(){

                public void apply(ModelThing it) {
                    GenericThingProvider.this.createThing(it, bridge, thingList, thingHandlerFactory);
                }
            };
            IterableExtensions.forEach(_things, (Procedures.Procedure1)_function_1);
        }
    }

    private boolean isSupportedByThingHandlerFactory(ThingTypeUID thingTypeUID, ThingHandlerFactory specific) {
        if (specific != null) {
            return specific.supportsThingType(thingTypeUID);
        }
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            boolean _supportsThingType = thingHandlerFactory.supportsThingType(thingTypeUID);
            if (!_supportsThingType) continue;
            return true;
        }
        return false;
    }

    private Thing getThingFromThingHandlerFactories(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory specific) {
        boolean _supportsThingType;
        Object _xblockexpression = null;
        boolean _and = false;
        boolean _notEquals = !Objects.equal((Object)specific, null);
        _and = !_notEquals ? false : (_supportsThingType = specific.supportsThingType(thingTypeUID));
        if (_and) {
            logger.trace("Creating thing from specific ThingHandlerFactory {} for thingType {}", (Object)specific, (Object)thingTypeUID);
            return this.getThingFromThingHandlerFactory(thingTypeUID, label, configuration, thingUID, bridgeUID, specific);
        }
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            logger.trace("Searching thingHandlerFactory for thingType: {}", (Object)thingTypeUID);
            boolean _supportsThingType_1 = thingHandlerFactory.supportsThingType(thingTypeUID);
            if (!_supportsThingType_1) continue;
            return this.getThingFromThingHandlerFactory(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private Thing getThingFromThingHandlerFactory(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory thingHandlerFactory) {
        Thing thing = thingHandlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
        boolean _equals = Objects.equal((Object)thing, null);
        if (_equals) {
            boolean _isAlive;
            boolean _not;
            Class<?> _class = thingHandlerFactory.getClass();
            String _simpleName = _class.getSimpleName();
            String _asString = thingTypeUID.getAsString();
            logger.debug("ThingHandlerFactory '{}' claimed it can handle '{}' type but actually did not. Queued for later refresh.", (Object)_simpleName, (Object)_asString);
            QueueContent _queueContent = new QueueContent(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
            this.queue.add(_queueContent);
            boolean _or = false;
            boolean _equals_1 = Objects.equal((Object)this.lazyRetryThread, null);
            _or = _equals_1 ? true : (_not = !(_isAlive = this.lazyRetryThread.isAlive()));
            if (_or) {
                Thread _thread;
                this.lazyRetryThread = _thread = new Thread(this.lazyRetryRunnable);
                this.lazyRetryThread.start();
            }
        } else {
            thing.setLabel(label);
        }
        return thing;
    }

    protected void _merge(Thing targetThing, Thing sourceThing) {
        ThingUID _bridgeUID = sourceThing.getBridgeUID();
        targetThing.setBridgeUID(_bridgeUID);
        Configuration _configuration = targetThing.getConfiguration();
        Configuration _configuration_1 = sourceThing.getConfiguration();
        this.merge(_configuration, _configuration_1);
        List _channels = sourceThing.getChannels();
        this.merge(targetThing, _channels);
    }

    protected void _merge(final Configuration target, final Configuration source) {
        Set _keySet = source.keySet();
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                Object _get = source.get(it);
                target.put(it, _get);
            }
        };
        IterableExtensions.forEach((Iterable)_keySet, (Procedures.Procedure1)_function);
    }

    protected void _merge(final Thing targetThing, List<Channel> source) {
        final ArrayList channelsToAdd = CollectionLiterals.newArrayList((Object[])new Channel[0]);
        Procedures.Procedure1<Channel> _function = new Procedures.Procedure1<Channel>(){

            public void apply(final Channel sourceChannel) {
                List _channels = targetThing.getChannels();
                Functions.Function1<Channel, Boolean> _function = new Functions.Function1<Channel, Boolean>(){

                    public Boolean apply(Channel it) {
                        ChannelUID _uID = it.getUID();
                        ChannelUID _uID_1 = sourceChannel.getUID();
                        return _uID.equals((Object)_uID_1);
                    }
                };
                Iterable targetChannels = IterableExtensions.filter((Iterable)_channels, (Functions.Function1)_function);
                Procedures.Procedure1<Channel> _function_1 = new Procedures.Procedure1<Channel>(){

                    public void apply(Channel it) {
                        GenericThingProvider.this.merge(it, sourceChannel);
                    }
                };
                IterableExtensions.forEach((Iterable)targetChannels, (Procedures.Procedure1)_function_1);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)targetChannels);
                if (_isEmpty) {
                    channelsToAdd.add(sourceChannel);
                }
            }
        };
        IterableExtensions.forEach(source, (Procedures.Procedure1)_function);
        ThingHelper.addChannelsToThing((Thing)targetThing, (Collection)channelsToAdd);
    }

    protected void _merge(Channel target, Channel source) {
        Configuration _configuration = target.getConfiguration();
        Configuration _configuration_1 = source.getConfiguration();
        this.merge(_configuration, _configuration_1);
    }

    private List<String> getParentPath(Bridge bridge) {
        ThingUID _uID = bridge.getUID();
        List bridgeIds = _uID.getBridgeIds();
        ThingUID _uID_1 = bridge.getUID();
        String _id = _uID_1.getId();
        bridgeIds.add(_id);
        return bridgeIds;
    }

    private List<Channel> createChannels(final ThingTypeUID thingTypeUID, final ThingUID thingUID, List<ModelChannel> modelChannels, List<ChannelDefinition> channelDefinitions) {
        ArrayList _xblockexpression = null;
        final HashSet addedChannelIds = CollectionLiterals.newHashSet((Object[])new String[0]);
        final ArrayList channels = CollectionLiterals.newArrayList((Object[])new Channel[0]);
        Procedures.Procedure1<ModelChannel> _function = new Procedures.Procedure1<ModelChannel>(){

            public void apply(ModelChannel it) {
                String _id = it.getId();
                boolean _add = addedChannelIds.add(_id);
                if (_add) {
                    String _id_1 = it.getId();
                    ChannelUID _channelUID = new ChannelUID(thingTypeUID, thingUID, _id_1);
                    String _type = it.getType();
                    ChannelBuilder _create = ChannelBuilder.create((ChannelUID)_channelUID, (String)_type);
                    Configuration _createConfiguration = GenericThingProvider.this.createConfiguration(it);
                    ChannelBuilder _withConfiguration = _create.withConfiguration(_createConfiguration);
                    Channel _build = _withConfiguration.build();
                    channels.add(_build);
                }
            }
        };
        IterableExtensions.forEach(modelChannels, (Procedures.Procedure1)_function);
        Procedures.Procedure1<ChannelDefinition> _function_1 = new Procedures.Procedure1<ChannelDefinition>(){

            public void apply(ChannelDefinition it) {
                String _id = it.getId();
                boolean _add = addedChannelIds.add(_id);
                if (_add) {
                    boolean _notEquals;
                    ChannelTypeUID _channelTypeUID = it.getChannelTypeUID();
                    ChannelType channelType = TypeResolver.resolve((ChannelTypeUID)_channelTypeUID);
                    boolean bl = _notEquals = !Objects.equal((Object)channelType, null);
                    if (_notEquals) {
                        String _id_1 = it.getId();
                        ChannelUID _channelUID = new ChannelUID(thingTypeUID, thingUID, _id_1);
                        String _itemType = channelType.getItemType();
                        ChannelBuilder _create = ChannelBuilder.create((ChannelUID)_channelUID, (String)_itemType);
                        ChannelTypeUID _channelTypeUID_1 = it.getChannelTypeUID();
                        ChannelBuilder _withType = _create.withType(_channelTypeUID_1);
                        Channel _build = _withType.build();
                        channels.add(_build);
                    } else {
                        String _id_2 = it.getId();
                        ChannelTypeUID _channelTypeUID_2 = it.getChannelTypeUID();
                        logger.warn("Could not create channel '{}' for thing '{}', because channel type '{}' could not be found.", new Object[]{_id_2, thingUID, _channelTypeUID_2});
                    }
                }
            }
        };
        IterableExtensions.forEach(channelDefinitions, (Procedures.Procedure1)_function_1);
        _xblockexpression = channels;
        return _xblockexpression;
    }

    private Configuration createConfiguration(ModelPropertyContainer propertyContainer) {
        Configuration _xblockexpression = null;
        final Configuration configuration = new Configuration();
        EList<ModelProperty> _properties = propertyContainer.getProperties();
        Procedures.Procedure1<ModelProperty> _function = new Procedures.Procedure1<ModelProperty>(){

            public void apply(ModelProperty it) {
                String _key = it.getKey();
                Object _value = it.getValue();
                configuration.put(_key, _value);
            }
        };
        IterableExtensions.forEach(_properties, (Procedures.Procedure1)_function);
        _xblockexpression = configuration;
        return _xblockexpression;
    }

    private ThingType getThingType(ThingTypeUID thingTypeUID) {
        ThingType _thingType = null;
        if (this.thingTypeRegistry != null) {
            Locale _locale = this.localeProvider.getLocale();
            _thingType = this.thingTypeRegistry.getThingType(thingTypeUID, _locale);
        }
        return _thingType;
    }

    protected void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    protected void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    public void modelChanged(String modelName, EventType type) {
        boolean _endsWith = modelName.endsWith("things");
        if (_endsWith && type != null) {
            switch (type) {
                case ADDED: {
                    ArrayList _newArrayList;
                    this.createThingsFromModel(modelName);
                    ArrayList _elvis = null;
                    ArrayList _get = this.thingsMap.get(modelName);
                    _elvis = _get != null ? _get : (_newArrayList = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList things = _elvis;
                    Procedures.Procedure1<Thing> _function = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutAddedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)things, (Procedures.Procedure1)_function);
                    break;
                }
                case MODIFIED: {
                    ArrayList _newArrayList_2;
                    ArrayList _newArrayList_1;
                    ArrayList _elvis_1 = null;
                    ArrayList _get_1 = this.thingsMap.get(modelName);
                    _elvis_1 = _get_1 != null ? _get_1 : (_newArrayList_1 = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    final ArrayList oldThings = _elvis_1;
                    Functions.Function1<Thing, ThingUID> _function_1 = new Functions.Function1<Thing, ThingUID>(){

                        public ThingUID apply(Thing it) {
                            return it.getUID();
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)oldThings, (Functions.Function1)_function_1);
                    final List oldThingsUIDs = IterableExtensions.toList((Iterable)_map);
                    this.createThingsFromModel(modelName);
                    ArrayList _elvis_2 = null;
                    ArrayList _get_2 = this.thingsMap.get(modelName);
                    _elvis_2 = _get_2 != null ? _get_2 : (_newArrayList_2 = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList currentThings = _elvis_2;
                    Functions.Function1<Thing, ThingUID> _function_2 = new Functions.Function1<Thing, ThingUID>(){

                        public ThingUID apply(Thing it) {
                            return it.getUID();
                        }
                    };
                    Iterable _map_1 = IterableExtensions.map((Iterable)currentThings, (Functions.Function1)_function_2);
                    final List currentThingUIDs = IterableExtensions.toList((Iterable)_map_1);
                    Functions.Function1<Thing, Boolean> _function_3 = new Functions.Function1<Thing, Boolean>(){

                        public Boolean apply(Thing it) {
                            ThingUID _uID = it.getUID();
                            boolean _contains = currentThingUIDs.contains(_uID);
                            return !_contains;
                        }
                    };
                    Iterable removedThings = IterableExtensions.filter((Iterable)oldThings, (Functions.Function1)_function_3);
                    Functions.Function1<Thing, Boolean> _function_4 = new Functions.Function1<Thing, Boolean>(){

                        public Boolean apply(Thing it) {
                            ThingUID _uID = it.getUID();
                            boolean _contains = oldThingsUIDs.contains(_uID);
                            return !_contains;
                        }
                    };
                    Iterable addedThings = IterableExtensions.filter((Iterable)currentThings, (Functions.Function1)_function_4);
                    Procedures.Procedure1<Thing> _function_5 = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutRemovedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)removedThings, (Procedures.Procedure1)_function_5);
                    Procedures.Procedure1<Thing> _function_6 = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutAddedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)addedThings, (Procedures.Procedure1)_function_6);
                    Procedures.Procedure1<Thing> _function_7 = new Procedures.Procedure1<Thing>(){

                        public void apply(final Thing newThing) {
                            boolean _notEquals;
                            Functions.Function1<Thing, Boolean> _function = new Functions.Function1<Thing, Boolean>(){

                                public Boolean apply(Thing it) {
                                    ThingUID _uID = it.getUID();
                                    ThingUID _uID_1 = newThing.getUID();
                                    return Objects.equal((Object)_uID, (Object)_uID_1);
                                }
                            };
                            Thing oldThing = (Thing)IterableExtensions.findFirst((Iterable)oldThings, (Functions.Function1)_function);
                            boolean bl = _notEquals = !Objects.equal((Object)oldThing, null);
                            if (_notEquals) {
                                boolean _not;
                                boolean _equals = ThingHelper.equals((Thing)oldThing, (Thing)newThing);
                                boolean bl2 = _not = !_equals;
                                if (_not) {
                                    GenericThingProvider.this.notifyListenersAboutUpdatedElement(oldThing, newThing);
                                }
                            }
                        }
                    };
                    IterableExtensions.forEach((Iterable)currentThings, (Procedures.Procedure1)_function_7);
                    break;
                }
                case REMOVED: {
                    ArrayList _newArrayList_3;
                    ArrayList _elvis_3 = null;
                    ArrayList _remove = this.thingsMap.remove(modelName);
                    _elvis_3 = _remove != null ? _remove : (_newArrayList_3 = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList things_1 = _elvis_3;
                    Procedures.Procedure1<Thing> _function_8 = new Procedures.Procedure1<Thing>(){

                        public void apply(Thing it) {
                            GenericThingProvider.this.notifyListenersAboutRemovedElement(it);
                        }
                    };
                    IterableExtensions.forEach((Iterable)things_1, (Procedures.Procedure1)_function_8);
                    break;
                }
            }
        }
    }

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        logger.debug("ThingHandlerFactory added {}", (Object)thingHandlerFactory);
        this.thingHandlerFactories.add(thingHandlerFactory);
        this.thingHandlerFactoryAdded(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
        this.thingHandlerFactoryRemoved();
    }

    private Object thingHandlerFactoryRemoved() {
        return null;
    }

    private void thingHandlerFactoryAdded(final ThingHandlerFactory thingHandlerFactory) {
        Set<String> _keySet = this.thingsMap.keySet();
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                GenericThingProvider.this.createThingsFromModelForThingHandlerFactory(it, thingHandlerFactory);
            }
        };
        IterableExtensions.forEach(_keySet, (Procedures.Procedure1)_function);
    }

    private void createThingsFromModelForThingHandlerFactory(final String modelName, final ThingHandlerFactory factory) {
        boolean _notEquals;
        Collection<Thing> _get = this.thingsMap.get(modelName);
        final Thing[] oldThings = (Thing[])((Thing[])Conversions.unwrapArray(_get, Thing.class)).clone();
        final ArrayList newThings = CollectionLiterals.newArrayList((Object[])new Thing[0]);
        boolean bl = _notEquals = !Objects.equal((Object)this.modelRepository, null);
        if (_notEquals) {
            boolean _notEquals_1;
            EObject _model = this.modelRepository.getModel(modelName);
            ThingModel model = (ThingModel)_model;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)model, null);
            if (_notEquals_1) {
                EList<ModelThing> _things = model.getThings();
                Procedures.Procedure1<ModelThing> _function = new Procedures.Procedure1<ModelThing>(){

                    public void apply(ModelThing it) {
                        GenericThingProvider.this.createThing(it, null, newThings, factory);
                    }
                };
                IterableExtensions.forEach(_things, (Procedures.Procedure1)_function);
            }
        }
        Procedures.Procedure1<Thing> _function_1 = new Procedures.Procedure1<Thing>(){

            public void apply(final Thing newThing) {
                boolean _notEquals;
                Functions.Function1<Thing, Boolean> _function = new Functions.Function1<Thing, Boolean>(){

                    public Boolean apply(Thing it) {
                        ThingUID _uID = it.getUID();
                        ThingUID _uID_1 = newThing.getUID();
                        return Objects.equal((Object)_uID, (Object)_uID_1);
                    }
                };
                Thing oldThing = (Thing)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)oldThings)), (Functions.Function1)_function);
                boolean bl = _notEquals = !Objects.equal((Object)oldThing, null);
                if (!_notEquals) {
                    ThingUID _uID = newThing.getUID();
                    logger.debug("Adding thing '{}' from model '{}.", (Object)_uID, (Object)modelName);
                    Collection _get = (Collection)GenericThingProvider.this.thingsMap.get(modelName);
                    _get.add(newThing);
                    GenericThingProvider.this.notifyListenersAboutAddedElement(newThing);
                }
            }
        };
        IterableExtensions.forEach((Iterable)newThings, (Procedures.Procedure1)_function_1);
    }

    public void merge(Object targetThing, Object source) {
        if (targetThing instanceof Thing && source instanceof List) {
            this._merge((Thing)targetThing, (List)source);
            return;
        }
        if (targetThing instanceof Configuration && source instanceof Configuration) {
            this._merge((Configuration)targetThing, (Configuration)source);
            return;
        }
        if (targetThing instanceof Channel && source instanceof Channel) {
            this._merge((Channel)targetThing, (Channel)source);
            return;
        }
        if (targetThing instanceof Thing && source instanceof Thing) {
            this._merge((Thing)targetThing, (Thing)source);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(targetThing, source).toString());
    }

    @Data
    private static final class QueueContent {
        private final ThingTypeUID _thingTypeUID;
        private final String _label;
        private final Configuration _configuration;
        private final ThingUID _thingUID;
        private final ThingUID _bridgeUID;
        private final ThingHandlerFactory _thingHandlerFactory;

        public QueueContent(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory thingHandlerFactory) {
            this._thingTypeUID = thingTypeUID;
            this._label = label;
            this._configuration = configuration;
            this._thingUID = thingUID;
            this._bridgeUID = bridgeUID;
            this._thingHandlerFactory = thingHandlerFactory;
        }

        @Pure
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this._thingTypeUID == null ? 0 : this._thingTypeUID.hashCode());
            result = 31 * result + (this._label == null ? 0 : this._label.hashCode());
            result = 31 * result + (this._configuration == null ? 0 : this._configuration.hashCode());
            result = 31 * result + (this._thingUID == null ? 0 : this._thingUID.hashCode());
            result = 31 * result + (this._bridgeUID == null ? 0 : this._bridgeUID.hashCode());
            result = 31 * result + (this._thingHandlerFactory == null ? 0 : this._thingHandlerFactory.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueContent other = (QueueContent)obj;
            if (this._thingTypeUID == null ? other._thingTypeUID != null : !this._thingTypeUID.equals((Object)other._thingTypeUID)) {
                return false;
            }
            if (this._label == null ? other._label != null : !this._label.equals(other._label)) {
                return false;
            }
            if (this._configuration == null ? other._configuration != null : !this._configuration.equals((Object)other._configuration)) {
                return false;
            }
            if (this._thingUID == null ? other._thingUID != null : !this._thingUID.equals((Object)other._thingUID)) {
                return false;
            }
            if (this._bridgeUID == null ? other._bridgeUID != null : !this._bridgeUID.equals((Object)other._bridgeUID)) {
                return false;
            }
            return !(this._thingHandlerFactory == null ? other._thingHandlerFactory != null : !this._thingHandlerFactory.equals(other._thingHandlerFactory));
        }

        @Pure
        public String toString() {
            String result = new ToStringHelper().toString((Object)this);
            return result;
        }

        @Pure
        public ThingTypeUID getThingTypeUID() {
            return this._thingTypeUID;
        }

        @Pure
        public String getLabel() {
            return this._label;
        }

        @Pure
        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Pure
        public ThingUID getThingUID() {
            return this._thingUID;
        }

        @Pure
        public ThingUID getBridgeUID() {
            return this._bridgeUID;
        }

        @Pure
        public ThingHandlerFactory getThingHandlerFactory() {
            return this._thingHandlerFactory;
        }
    }
}

