/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.voice.internal.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.io.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.io.voice.text.InterpretationException;

public class StandardHumanLanguageInterpreter
implements HumanLanguageInterpreter {
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;
    private final Set<Locale> supportedLocales = Collections.unmodifiableSet(Collections.singleton(Locale.ENGLISH));
    private final String PARDON = "I didn't quite follow that.";
    private final String MORE_THAN_ONE = "There's more than one thing with a similar name.";
    private final String NO_ONE = "There is no thing named like that.";
    private final String STATE_ON = "on";
    private final String STATE_OFF = "off";

    @Override
    public String interpret(Locale locale, String text) throws InterpretationException {
        if (locale != Locale.ENGLISH) {
            throw new InterpretationException(String.valueOf(locale.getDisplayLanguage(Locale.ENGLISH)) + " is not supported at the moment.");
        }
        String[] tokens = text.trim().toLowerCase().split("\\s++");
        if (tokens.length == 0) {
            throw new InterpretationException("I didn't quite follow that.");
        }
        String first = tokens[0];
        if (first.equals("turn") && tokens.length >= 3) {
            OnOffType newState;
            int pos = 1;
            int end = tokens.length;
            String state = "on";
            if (tokens[1].equals("on")) {
                ++pos;
            } else if (tokens[1].equals("off")) {
                ++pos;
                state = "off";
            } else if (tokens[end - 1].equals("on")) {
                --end;
            } else if (tokens[end - 1].equals("off")) {
                --end;
                state = "off";
            } else {
                throw new InterpretationException("I didn't quite follow that.");
            }
            ArrayList<Item> items = this.getMatchingItems(Arrays.copyOfRange(tokens, pos, end), OnOffType.class);
            if (items.size() <= 0) {
                throw new InterpretationException("There is no thing named like that.");
            }
            if (items.size() > 1) {
                throw new InterpretationException("There's more than one thing with a similar name.");
            }
            Item item = items.get(0);
            OnOffType oldState = (OnOffType)item.getStateAs(OnOffType.class);
            if (oldState.equals((Object)(newState = OnOffType.valueOf((String)state.toUpperCase())))) {
                return "It's already " + state + ".";
            }
            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)newState));
            return "Ok";
        }
        throw new InterpretationException("I didn't quite follow that.");
    }

    private ArrayList<Item> getMatchingItems(String[] nameFragments, Class<?> commandType) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : this.itemRegistry.getAll()) {
            HashSet<String> parts = new HashSet<String>(this.splitName(item.getName(), true));
            boolean allMatch = true;
            String[] stringArray = nameFragments;
            int n = nameFragments.length;
            int n2 = 0;
            while (n2 < n) {
                String fragment = stringArray[n2];
                allMatch = allMatch && parts.contains(fragment.toLowerCase());
                ++n2;
            }
            if (!allMatch || commandType != null && !item.getAcceptedCommandTypes().contains(commandType)) continue;
            items.add(item);
        }
        return items;
    }

    private ArrayList<String> splitName(String name, boolean toLowerCase) {
        String[] split = name.split("(?<!^)(?=[A-Z])|_|\\s+");
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (i < split.length) {
            String part = split[i].trim();
            if (part.length() > 0) {
                if (toLowerCase) {
                    part = part.toLowerCase();
                }
                parts.add(part);
            }
            ++i;
        }
        return parts;
    }

    @Override
    public Set<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

