/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableBase64 {
    private static Object encoderInstance;
    private static Method encodeMethod;
    private static Object decoderInstance;
    private static Method decodeMethod;
    private static volatile boolean isInitialized;
    private static Encoder basicEncoder;
    private static Decoder basicDecoder;

    static {
        isInitialized = false;
        basicEncoder = new Encoder();
        basicDecoder = new Decoder();
    }

    public static void initialize() {
        if (isInitialized) {
            PortableBase64.logDebug("PortableBase64 class already initialized");
            return;
        }
        boolean isJava8OrNewer = true;
        try {
            Class.forName("java.util.Base64", false, PortableBase64.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            isJava8OrNewer = false;
        }
        PortableBase64.logDebug("PortableBase64 class is running on JavaSE " + (isJava8OrNewer ? ">=8" : "<=7"));
        try {
            if (isJava8OrNewer) {
                PortableBase64.initializeJava8();
            } else {
                PortableBase64.initializeJava7();
            }
            String encodedAsString = (String)encodeMethod.invoke(encoderInstance, new Object[]{"foobar".getBytes("UTF-8")});
            if (!"Zm9vYmFy".equals(encodedAsString)) {
                throw new IllegalAccessError("encode does not work as expected");
            }
            byte[] decodedAsByteArray = (byte[])decodeMethod.invoke(decoderInstance, "Zm9vYmFy");
            String decodedAsString = new String(decodedAsByteArray, "UTF-8");
            if (!"foobar".equals(decodedAsString)) {
                throw new IllegalAccessError("decode does not work as expected");
            }
            isInitialized = true;
        }
        catch (Exception ex) {
            PortableBase64.logError("Could not initialize PortableBase64 class- Check your Java environment to run on Java 7 or 8 or later.", ex);
            encodeMethod = null;
            decodeMethod = null;
        }
    }

    private static void initializeJava7() throws Exception {
        Class<?> datatypeConverterClass = Class.forName("javax.xml.bind.DatatypeConverter", false, PortableBase64.class.getClassLoader());
        encodeMethod = datatypeConverterClass.getMethod("printBase64Binary", byte[].class);
        decodeMethod = datatypeConverterClass.getMethod("parseBase64Binary", String.class);
    }

    private static void initializeJava8() throws Exception {
        Class<?> baseClass = Class.forName("java.util.Base64", false, PortableBase64.class.getClassLoader());
        Class<?>[] innerClasses = baseClass.getDeclaredClasses();
        Class<?> encoderClass = null;
        Class<?> decoderClass = null;
        int i = 0;
        while (i < innerClasses.length) {
            Class<?> c = innerClasses[i];
            if (c.getName().equals("java.util.Base64$Encoder")) {
                encoderClass = c;
            } else if (c.getName().equals("java.util.Base64$Decoder")) {
                decoderClass = c;
            }
            ++i;
        }
        if (encoderClass == null) {
            throw new IllegalAccessError("Could not find encoderClass java.util.Base64$Encoder");
        }
        if (decoderClass == null) {
            throw new IllegalAccessError("Could not find decoderClass java.util.Base64$Decoder");
        }
        encoderInstance = baseClass.getMethod("getEncoder", new Class[0]).invoke(null, null);
        decoderInstance = baseClass.getMethod("getDecoder", new Class[0]).invoke(null, null);
        encodeMethod = encoderClass.getMethod("encodeToString", byte[].class);
        decodeMethod = decoderClass.getMethod("decode", String.class);
    }

    private static void logError(String msg, Exception ex) {
        Logger l = LoggerFactory.getLogger(PortableBase64.class);
        l.error(msg, (Throwable)ex);
    }

    private static void logDebug(String msg) {
        Logger l = LoggerFactory.getLogger(PortableBase64.class);
        l.debug(msg);
    }

    public static Encoder getEncoder() {
        return basicEncoder;
    }

    public static Decoder getDecoder() {
        return basicDecoder;
    }

    public static class Decoder {
        public byte[] decode(String s) {
            try {
                if (!isInitialized) {
                    throw new IllegalStateException("PortableBase64 is not initialized");
                }
                Object res = decodeMethod.invoke(decoderInstance, s);
                byte[] b = (byte[])res;
                if (b.length == 0 && s.length() > 0) {
                    throw new IllegalArgumentException("decode returned empty result");
                }
                return b;
            }
            catch (IllegalStateException ise) {
                throw ise;
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                PortableBase64.logError("PortableBase64 - Could not decode", ex);
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
    }

    public static class Encoder {
        public String encode(byte[] base64) {
            try {
                if (!isInitialized) {
                    throw new IllegalStateException("PortableBase64 is not initialized");
                }
                Object res = encodeMethod.invoke(encoderInstance, new Object[]{base64});
                return (String)res;
            }
            catch (IllegalStateException ise) {
                throw ise;
            }
            catch (Exception ex) {
                PortableBase64.logError("PortableBase64 - Could not encode", ex);
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
    }
}

