/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.ItemsChangeListener;
import org.eclipse.smarthome.core.items.ManagedItemProvider;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.StateDescriptionProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRegistryImpl
extends AbstractRegistry<Item, String>
implements ItemRegistry,
ItemsChangeListener {
    private final Logger logger = LoggerFactory.getLogger(ItemRegistryImpl.class);
    private StateDescriptionProviderTracker stateDescriptionProviderTracker;
    private List<StateDescriptionProvider> stateDescriptionProviders = Collections.synchronizedList(new ArrayList());
    private Map<String, Integer> stateDescriptionProviderRanking = new ConcurrentHashMap<String, Integer>();

    @Override
    public void allItemsChanged(ItemProvider provider, Collection<String> oldItemNames) {
        HashMap<String, Item> oldItemsMap = new HashMap<String, Item>();
        Collection oldItems = (Collection)this.elementMap.get(provider);
        if (oldItemNames == null || oldItemNames.isEmpty()) {
            oldItemNames = new HashSet<String>();
            if (oldItems != null && oldItems.size() > 0) {
                for (Item oldItem : oldItems) {
                    oldItemsMap.put(oldItem.getName(), oldItem);
                }
            }
        } else {
            for (Item item : oldItems) {
                if (!oldItemNames.contains(item.getName())) continue;
                oldItemsMap.put(item.getName(), item);
            }
        }
        Collection providedItems = provider.getAll();
        CopyOnWriteArrayList<Item> items = new CopyOnWriteArrayList<Item>();
        this.elementMap.put(provider, items);
        for (Item item : providedItems) {
            Item oldItem = (Item)oldItemsMap.get(item.getName());
            if (oldItem == null) {
                try {
                    this.onAddElement(item);
                    items.add(item);
                    for (RegistryChangeListener listener : this.listeners) {
                        listener.added(item);
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.logger.warn("Could not add item: " + ex.getMessage(), (Throwable)ex);
                }
            } else if (!oldItem.equals(item)) {
                try {
                    this.onAddElement(item);
                    items.add(item);
                    for (RegistryChangeListener listener : this.listeners) {
                        listener.updated(oldItem, item);
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.logger.warn("Could not add item: " + ex.getMessage(), (Throwable)ex);
                }
            } else {
                items.add(oldItem);
            }
            oldItemsMap.remove(item.getName());
        }
        for (Item removedItem : oldItemsMap.values()) {
            for (RegistryChangeListener listener : this.listeners) {
                listener.removed(removedItem);
            }
        }
    }

    @Override
    public Item getItem(String name) throws ItemNotFoundException {
        for (Item item : this.getItems()) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        throw new ItemNotFoundException(name);
    }

    @Override
    public Item get(String itemName) {
        try {
            return this.getItem(itemName);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return null;
        }
    }

    @Override
    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        Collection<Item> items = this.getItems(name);
        if (items.isEmpty()) {
            throw new ItemNotFoundException(name);
        }
        if (items.size() > 1) {
            throw new ItemNotUniqueException(name, items);
        }
        return items.iterator().next();
    }

    @Override
    public Collection<Item> getItems() {
        return this.getAll();
    }

    @Override
    public Collection<Item> getItemsOfType(String type) {
        ArrayList<Item> matchedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!item.getType().equals(type)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    @Override
    public Collection<Item> getItems(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        ArrayList<Item> matchedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!item.getName().matches(regex)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    private void addToGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            try {
                Item groupItem = this.getItem(groupName);
                if (!(groupItem instanceof GroupItem)) continue;
                ((GroupItem)groupItem).addMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
    }

    private void initializeItem(Item item) throws IllegalArgumentException {
        ItemUtil.assertValidItemName(item.getName());
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.setEventPublisher(this.eventPublisher);
            genericItem.setStateDescriptionProviders(this.stateDescriptionProviders);
            genericItem.initialize();
        }
        if (item instanceof GroupItem) {
            this.addMembersToGroupItem((GroupItem)item);
        }
        this.addToGroupItems(item, item.getGroupNames());
    }

    private void addMembersToGroupItem(GroupItem groupItem) {
        for (Item i : this.getItems()) {
            if (!i.getGroupNames().contains(groupItem.getName())) continue;
            groupItem.addMember(i);
        }
    }

    private void removeFromGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            try {
                Item groupItem = this.getItem(groupName);
                if (!(groupItem instanceof GroupItem)) continue;
                ((GroupItem)groupItem).removeMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
    }

    @Override
    protected void onAddElement(Item element) throws IllegalArgumentException {
        this.initializeItem(element);
    }

    @Override
    protected void onRemoveElement(Item element) {
        this.removeFromGroupItems(element, element.getGroupNames());
    }

    @Override
    protected void onUpdateElement(Item oldItem, Item item) {
        this.removeFromGroupItems(oldItem, oldItem.getGroupNames());
        this.addToGroupItems(item, item.getGroupNames());
        if (item instanceof GroupItem) {
            this.addMembersToGroupItem((GroupItem)item);
        }
    }

    @Override
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(eventPublisher);
        }
    }

    @Override
    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(null);
        }
    }

    @Override
    public Collection<Item> getItemsByTag(String ... tags) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!this.itemHasTags(item, tags)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    private boolean itemHasTags(Item item, String ... tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (!item.hasTag(tag)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public <T extends GenericItem> Collection<T> getItemsByTag(Class<T> typeFilter, String ... tags) {
        ArrayList<GenericItem> filteredItems = new ArrayList<GenericItem>();
        Collection<Item> items = this.getItemsByTag(tags);
        for (Item item : items) {
            if (!typeFilter.isInstance(item)) continue;
            filteredItems.add((GenericItem)item);
        }
        return filteredItems;
    }

    @Override
    public Collection<Item> getItemsByTagAndType(String type, String ... tags) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        for (Item item : this.getItemsOfType(type)) {
            if (!this.itemHasTags(item, tags)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    @Override
    public Item remove(String itemName, boolean recursive) {
        if (this.managedProvider != null) {
            return ((ManagedItemProvider)this.managedProvider).remove(itemName, recursive);
        }
        throw new IllegalStateException("ManagedProvider is not available");
    }

    @Override
    protected void notifyListenersAboutAddedElement(Item element) {
        super.notifyListenersAboutAddedElement(element);
        this.postEvent(ItemEventFactory.createAddedEvent(element));
    }

    @Override
    protected void notifyListenersAboutRemovedElement(Item element) {
        super.notifyListenersAboutRemovedElement(element);
        this.postEvent(ItemEventFactory.createRemovedEvent(element));
    }

    @Override
    protected void notifyListenersAboutUpdatedElement(Item oldElement, Item element) {
        super.notifyListenersAboutUpdatedElement(oldElement, element);
        this.postEvent(ItemEventFactory.createUpdateEvent(element, oldElement));
    }

    protected void activate(ComponentContext componentContext) {
        this.stateDescriptionProviderTracker = new StateDescriptionProviderTracker(componentContext.getBundleContext());
        this.stateDescriptionProviderTracker.open();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.stateDescriptionProviderTracker.close();
        this.stateDescriptionProviderTracker = null;
    }

    private final class StateDescriptionProviderTracker
    extends ServiceTracker<StateDescriptionProvider, StateDescriptionProvider> {
        public StateDescriptionProviderTracker(BundleContext context) {
            super(context, StateDescriptionProvider.class.getName(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StateDescriptionProvider addingService(ServiceReference<StateDescriptionProvider> reference) {
            StateDescriptionProvider provider = (StateDescriptionProvider)this.context.getService(reference);
            Object serviceRanking = reference.getProperty("service.ranking");
            if (serviceRanking instanceof Integer) {
                ItemRegistryImpl.this.stateDescriptionProviderRanking.put(provider.getClass().getName(), (Integer)serviceRanking);
            } else {
                ItemRegistryImpl.this.stateDescriptionProviderRanking.put(provider.getClass().getName(), 0);
            }
            List list = ItemRegistryImpl.this.stateDescriptionProviders;
            synchronized (list) {
                ItemRegistryImpl.this.stateDescriptionProviders.add(provider);
                Collections.sort(ItemRegistryImpl.this.stateDescriptionProviders, new Comparator<StateDescriptionProvider>(){

                    @Override
                    public int compare(StateDescriptionProvider provider1, StateDescriptionProvider provider2) {
                        return ((Integer)ItemRegistryImpl.this.stateDescriptionProviderRanking.get(provider2.getClass().getName())).compareTo((Integer)ItemRegistryImpl.this.stateDescriptionProviderRanking.get(provider1.getClass().getName()));
                    }
                });
                for (Item item : ItemRegistryImpl.this.getItems()) {
                    ((GenericItem)item).setStateDescriptionProviders(ItemRegistryImpl.this.stateDescriptionProviders);
                }
            }
            return provider;
        }

        public void removedService(ServiceReference<StateDescriptionProvider> reference, StateDescriptionProvider service) {
            ItemRegistryImpl.this.stateDescriptionProviders.remove(service);
            ItemRegistryImpl.this.stateDescriptionProviderRanking.remove(service.getClass().getName());
            for (Item item : ItemRegistryImpl.this.getItems()) {
                ((GenericItem)item).setStateDescriptionProviders(ItemRegistryImpl.this.stateDescriptionProviders);
            }
        }
    }
}

